function data()
	local t = { }

	t.name = _("Stair snapper")
	t.desc = _("For internal use of stair-asset-mod by DarkMo.")

	t.yearFrom = 1800
	t.yearTo = 1801

	t.shapeWidth = 1.0
	t.shapeStep = 1.0
	t.shapeSleeperStep = 8.0 / 12.0

	t.ballastHeight = 0
	t.ballastCutOff = 0

	t.sleeperBase = t.ballastHeight
	t.sleeperLength = 0
	t.sleeperWidth = 0
	t.sleeperHeight = 0
	t.sleeperCutOff = 0

	t.railTrackWidth = 0.5
	t.railBase = t.sleeperBase + t.sleeperHeight
	t.railHeight = 0
	t.railWidth = 0
	t.railCutOff = 0
    
    t.embankmentSlopeLow = 0.75
    t.embankmentSlopeHigh = 2.5

	t.catenaryBase = 5.917 + t.railBase + t.railHeight
	t.catenaryHeight = 0
	t.catenaryPoleDistance = 25.0

	t.trackDistance = 5.0

	t.speedLimit = 120.0 / 3.6
	t.speedCoeffs = { .85, 30.0, .6 }		-- curve speed limit = a * (radius + b) ^ c

	t.ballastMaterial = "track/invis.mtl"
	t.sleeperMaterial = "track/invis.mtl"
	t.railMaterial = "track/invis.mtl"
	t.catenaryMaterial = "track/invis.mtl"
	t.trackMaterial = "track/invis.mtl"
	t.tunnelWallMaterial = "track/invis.mtl"
	t.tunnelHullMaterial = "track/invis.mtl"

	t.catenaryPoleModel = "railroad/power_pole_2.mdl"
	t.catenaryMultiPoleModel = "railroad/power_pole_1.mdl"
	t.catenaryMultiGirderModel = "railroad/power_pole_1a.mdl"
	t.catenaryMultiInnerPoleModel = "railroad/power_pole_1b.mdl"

	t.bumperModel = "railroad/bumper.mdl"
	t.switchSignalModel = "railroad/switch_box.mdl"

	t.fillGroundTex = "forest_floor.lua"
	t.borderGroundTex = "forest_floor.lua"

	t.railModel = "asset/empty.mdl"
	t.sleeperModel = "asset/empty.mdl"
	t.trackStraightModel = {
		"asset/empty.mdl",
		"asset/empty.mdl",
		"asset/empty.mdl",
		"asset/empty.mdl",
	}
	t.cost = 50.0

	return t
end
