local function pRequire(modulName)
    local state, result_or_error = pcall(require, modulName)
    if state then
        return result_or_error
    else
        return nil, result_or_error
    end
end

function data()
	return {
	  info = {
		minorVersion = 0,
		severityAdd = "NONE",
		severityRemove = "NONE",
		name = _("Solarpark-Assets"),
		description = _("Enthält diverse Solarpanele.\n\nSie sind als ziehbare Assets, und einzeln platzierbar vorhanden."),
		tags = { "Europe", "Misc", "Asset", "Fence", "solar", "panel" },
		priority = 0, 
		authors = {
		  {
			name = "JAG-999",
			role = "CREATOR",
		  },
		},
		dependencies = { "snowball_fences_1" },
		modId = "jag_solarpark_1",

		requiredMods = {
			{
				modId = "snowball_fences_1",
				tfnetId = 5041,
				steamId = 1957631242,
				minMinorVersion = 10,
			},
		}
  	},
	  runFn = function ()
		local fences = pRequire("snowball/fences/main")

		if not fences then
			return
		end

		fences.fences["jag_solarp_1"] = {
		{
		-- Set Platzhalter
		post = "asset/misc/jag_solarpanel_1.mdl", 
		middle = nil,
		decoration = nil,
		length = 4.2,
		offset = {0.2, 0.5, 0.2},
		invertedModel = false,
	},{
		-- Set Platzhalter
		post = "asset/misc/jag_solarpanel_2.mdl", 
		middle = nil, 
		decoration = nil,
		length = 1.605,
		offset = {0.2, 0.5, 0.2},
		invertedModel = false,
	},{
		-- Set Platzhalter
		post = "asset/misc/jag_solarpanel_pm_3.mdl", 
		middle = "asset/misc/jag_solarpanel_op_3.mdl",
		decoration = nil,
		length = 4.0,
		offset = {0.2, 0.5, 0.2},
		invertedModel = false,
	}}

	end
}
end
