local function pRequire(modulName)
    local state, result_or_error = pcall(require, modulName)
    if state then
        return result_or_error
    else
        return nil, result_or_error
    end
end
local config = require "jag/trafohaeuser_1/config"

function data()
	return {
	  info = {
		minorVersion = 0,
		severityAdd = "NONE",
		severityRemove = "NONE",
		name = _("Trafohäuser"),
		description = _("Enthält diverse Trafohäuser als Erweiterung der Stromtrassen-Mod."),
		tags = { "Europe", "Misc", "Asset", "Trafohaus", "Strom", "Power" },
		priority = 0, 
		authors = {
		  {
			name = "JAG-999",
			role = "CREATOR",
		  },
		},
		requiredMods = { -- optional, Informationen über geladene Mods
			{ -- Angaben über einen oder mehrere Mods
				modId= "snowball_powerline_1", -- optional, modid
				tfnetId = 5315, -- optional, id der Webdisk auf transportfever.net
				url = "https://www.transportfever.net/filebase/index.php?entry/5315-stromtrassen/", -- optional, url zum Download der Mod
				minMinorVersion = 4 -- optional, minimale minorVersion
			}, -- optional, weitere Mods, durch Komma getrennt
		},
		
  		visible = true,
	  },
	  runFn = function()
		local power = pRequire("snowball/powerline/main")

		if not power then
			return
		end
		config.load()		
	  end


}
end
