local creekBridge = require("creek_bridge_A")

function data()
	return {
		info = {
			minorVersion = 2,
			severityAdd = "NONE",
			severityRemove = "NONE",
			name = _("name"),
			description = _("moddesc"),

			authors = {
				{   name = "melectro",  role = "CREATOR",	text = 'Constructor',	steamProfile = "70790454",	tfnetId = 24295,},
				},
			tags = { "street", "track", "script",  },
		},
		postRunFn = function (settings, params)
			local hasAutobahnMod = api.res.streetTypeRep.find('Autobahn.lua') >= 0
			local hasAbBauMod = api.res.streetTypeRep.find('Autobahn_construction.lua') >= 0
			local haspipeMod = api.res.trackTypeRep.find('pipe.lua') >= 0

			local has1000 = api.res.trackTypeRep.find('eis_os_1000mm.lua') >= 0
			local has760 = api.res.trackTypeRep.find('760_beton_betonmast.lua') >= 0

			local trackPath = "ui/tracks/"
			local TrackIcons = {
						( trackPath.."standard.tga"),	
						( trackPath.."high_speed.tga"),	
			}
			local TrackIconsA1 = TrackIcons
			local TrackIconsA2 = TrackIcons

			if has1000 then
				local Track1000Icons = {
							( trackPath.."eis_os_750mm.tga"),	
							( trackPath.."eis_os_1000mm.tga"),	
							( trackPath.."eis_os_1000mm_5_5m.tga"),	
				}			
				TrackIcons = creekBridge.mergeTable(TrackIcons, Track1000Icons)
			end
			
			if has760 then
--				local from = { 0, 1970, 2010}
--				local to   = { 0,    0,    0}
				TrackIcons = creekBridge.mergeTable(TrackIcons, {( trackPath.."760_holz_mariazellerbahn.tga"),})
				TrackIconsA1 = creekBridge.mergeTable(TrackIcons, {( trackPath.."760_beton_betonmast.tga"),})
				TrackIconsA2 = creekBridge.mergeTable(TrackIconsA1, {( trackPath.."760_y_betonmast.tga"),})
			end


			local t = nil
			local AbnPath = "ui/streets/"
			local setparPath = "ui/streets/standard/"
			local setparIcons = { 
						( setparPath.."town_small_new.tga"),
						( setparPath.."town_medium_new.tga"),
						( setparPath.."town_large_new.tga"),
						( setparPath.."town_x_large_new.tga"),
						( setparPath.."town_small_one_way_new.tga"),
						( setparPath.."town_medium_one_way_new.tga"),
						( setparPath.."town_large_one_way_new.tga"),
						( setparPath.."country_small_new.tga"),
						( setparPath.."country_medium_new.tga"),
						( setparPath.."country_large_new.tga"),
						( setparPath.."country_x_large_new.tga"),
						( setparPath.."country_small_one_way_new.tga"),
						( setparPath.."country_medium_one_way_new.tga"),
						( setparPath.."country_large_one_way_new.tga"),
			}
			local setparstreetwidth =
			{
				5,7,11,15,3.5,7,9,2,3,10.5,14.5,0.5,3,8.5  --5,7,11,15,4,7,9,2,3,11,15,1,3,9
			}
			local OldstreetIcons = {
						( setparPath.."town_small_old.tga"),
						( setparPath.."town_medium_old.tga"),
						( setparPath.."town_large_old.tga"),
						( setparPath.."EraA_country_small_old.tga"),
						( setparPath.."EraA_country_medium_old.tga"),
						( setparPath.."EraA_country_large_old.tga"),
			}
			local Oldstreetwidth =
			{
				5,7,11,5,7,11
			}
			local AutobahnIcons = {
							( AbnPath.."Autobahn_ausfahrt_large.tga"),
							( AbnPath.."Autobahn_ausfahrt_large_concrete.tga"),
							( AbnPath.."Autobahn.tga"),
							( AbnPath.."Autobahn_concrete.tga"),
							( AbnPath.."Autobahn_ausfahrt.tga"),
							( AbnPath.."Autobahn_ausfahrt_medium.tga"),
							( AbnPath.."country_medium_new_asphalt.tga"),
							( AbnPath.."Autobahn_ausfahrt_concrete.tga"),
							( AbnPath.."Autobahn_ausfahrt_medium_concrete.tga"),
							( AbnPath.."country_medium_new_concrete.tga"),
					}
			local Abnwidth =
			{
				8,8,12,12,1.5,3.5,3.5,1.5,3.5,3.5
			}	
			local AbBauIcons = {
							( AbnPath.."Autobahn_construction.tga"),
							( AbnPath.."Autobahn_construction_concrete.tga"),
					}
			local AbBauwidth =
			{
				12,12
			}	

			local climatePath = "ui/ground/"
			local climateIcons = {
							( climatePath.."Adry.tga"),
							( climatePath.."Awater.tga"),
					}
			local climateTrackIcons = {
							( climatePath.."Atrackdry.tga"),
							( climatePath.."Atrackwater.tga"),
					}

			local street_fileA = "creek_bridge_streetA"
			local street_fileA1 = "creek_bridge_streetA1"
			local street_fileA2 = "creek_bridge_streetA2"
			local track_fileA = "creek_bridge_trackA"
			local track_fileA1 = "creek_bridge_trackA1"
			local track_fileA2 = "creek_bridge_trackA2"

			local ModParamsA = {
				paramPathA = setparPath,
				paramIconsA = OldstreetIcons,
				streetwidthA = Oldstreetwidth,
				Abn_PathA = AbnPath,
				HasPipeA = haspipeMod,
				TrackIconsA = TrackIcons,
			}
			local ModParamsA1 = {
				paramPathA = setparPath,
				paramIconsA = OldstreetIcons,
				streetwidthA = Oldstreetwidth,
				Abn_PathA = AbnPath,
				HasPipeA = haspipeMod,
				TrackIconsA = TrackIconsA1,
			}
			local ModParamsA2 = {
				paramPathA = setparPath,
				paramIconsA = OldstreetIcons,
				streetwidthA = Oldstreetwidth,
				Abn_PathA = AbnPath,
				HasPipeA = haspipeMod,
				TrackIconsA = TrackIconsA2,
			}


----------------------
--  era A track bridge
----------------------
			local trackCon, trackTemp, trackDyn = creekBridge.createConstructionRail(track_fileA, _("desc"),  _("menudesc"), 1850, 1970 )
			local trackCon760, trackTemp760, trackDyn760 = creekBridge.createConstructionRail(track_fileA, _("desc"),  _("menudesc"), 1970, 2010 )
			local trackCon760y, trackTemp760y, trackDyn760y = creekBridge.createConstructionRail(track_fileA, _("desc"),  _("menudesc"), 2010, 0 )

			-- TODO: What parameters should be shown in the ui?
			-- trackDyn = only when first build
			-- trackCon = when first build and in configuration mode (elements will be shown first)
--			creekBridge.ui.addNumberOfTracks(trackDyn)
--			creekBridge.ui.addNumberOfBridges(trackDyn)
--			creekBridge.ui.addClimate(trackDyn, climateTrackIcons)

			local NumbOfBridges = {
						_("1"),_("2"),_("3"),
					}
			creekBridge.ui.addNumberOfBridges(trackCon,NumbOfBridges)
			creekBridge.ui.addNumberOfTracks(trackCon)

			creekBridge.ui.addHeight(trackCon)
			creekBridge.ui.addSignHeight(trackCon)
			creekBridge.ui.addClimate(trackCon, climateTrackIcons)
			creekBridge.ui.addWaterHeight(trackCon)
			creekBridge.ui.addCatenary(trackCon)
			creekBridge.ui.addTrackType(trackCon,TrackIcons)

			creekBridge.setConDescScriptFileAndParams(trackCon, track_fileA, ModParamsA)
			creekBridge.addToRepository(track_fileA, trackCon, trackTemp, trackDyn)

------ 760 track
			creekBridge.ui.addNumberOfBridges(trackCon760,NumbOfBridges)
			creekBridge.ui.addNumberOfTracks(trackCon760)

			creekBridge.ui.addHeight(trackCon760)
			creekBridge.ui.addSignHeight(trackCon760)
			creekBridge.ui.addClimate(trackCon760, climateTrackIcons)
			creekBridge.ui.addWaterHeight(trackCon760)
			creekBridge.ui.addCatenary(trackCon760)
			creekBridge.ui.addTrackType(trackCon760,TrackIconsA1)

			creekBridge.setConDescScriptFileAndParams(trackCon760, track_fileA1, ModParamsA1)
			creekBridge.addToRepository(track_fileA1, trackCon760, trackTemp760, trackDyn760)
			
------ 760y track	
			creekBridge.ui.addNumberOfBridges(trackCon760y,NumbOfBridges)
			creekBridge.ui.addNumberOfTracks(trackCon760y)

			creekBridge.ui.addHeight(trackCon760y)
			creekBridge.ui.addSignHeight(trackCon760y)
			creekBridge.ui.addClimate(trackCon760y, climateTrackIcons)
			creekBridge.ui.addWaterHeight(trackCon760y)
			creekBridge.ui.addCatenary(trackCon760y)
			creekBridge.ui.addTrackType(trackCon760y,TrackIconsA2)

			creekBridge.setConDescScriptFileAndParams(trackCon760y, track_fileA2, ModParamsA2)
			creekBridge.addToRepository(track_fileA2, trackCon760y, trackTemp760y, trackDyn760y)

-----------------------
--  era A street bridge
-----------------------

			local streetConA, streetTemplateA, streetDynA = creekBridge.createConstructionStreet(street_fileA, _("desc"),  _("menudesc"), 1850, 1925 )
			local streetConA1, streetTemplateA1, streetDynA1 = creekBridge.createConstructionStreet(street_fileA, _("desc"),  _("menudesc"), 1925, 1930 )
			local streetConA2, streetTemplateA2, streetDynA2 = creekBridge.createConstructionStreet(street_fileA, _("desc"),  _("menudesc"), 1930, 0 )

			NumbOfBridges = {
						_("1"),_("2"),_("3"),_("4"),_("5"),_("6"),_("7"),_("8"),_("9"),_("10"),_("11"),_("12"),
					}
			creekBridge.ui.addNumberOfBridges(streetConA,NumbOfBridges)
			creekBridge.ui.addNumberOfBridges(streetConA1,NumbOfBridges)
			creekBridge.ui.addNumberOfBridges(streetConA2,NumbOfBridges)
			creekBridge.ui.addHeight(streetConA)
			creekBridge.ui.addHeight(streetConA1)
			creekBridge.ui.addHeight(streetConA2)
			creekBridge.ui.addSignHeight(streetConA)
			creekBridge.ui.addSignHeight(streetConA1)
			creekBridge.ui.addSignHeight(streetConA2)

			creekBridge.ui.addClimate(streetConA, climateIcons)
			creekBridge.ui.addClimate(streetConA1, climateIcons)
			creekBridge.ui.addClimate(streetConA2, climateIcons)
			creekBridge.ui.addWaterHeight(streetConA)
			creekBridge.ui.addWaterHeight(streetConA1)
			creekBridge.ui.addWaterHeight(streetConA2)

			ModParamsA = {
				paramPathA = setparPath,
				paramIconsA = OldstreetIcons,
				streetwidthA = Oldstreetwidth,
				Abn_PathA = AbnPath,
				HasPipeA = haspipeMod,
				TrackIconsA = TrackIcons,
			}

			creekBridge.ui.addStreetTypeIcons(streetConA, ModParamsA.paramIconsA)
			creekBridge.setConDescScriptFileAndParams(streetConA, street_fileA, ModParamsA)
			creekBridge.addToRepository(street_fileA, streetConA, streetTemplateA, streetDynA)


			ModParamsA1 = {
				paramPathA = setparPath,
				paramIconsA = setparIcons,
				streetwidthA = setparstreetwidth,
				Abn_PathA = AbnPath,
				HasPipeA = haspipeMod,
				TrackIconsA = TrackIconsA1,
			}

--			creekBridge.ui.addStreetTypeIcons(streetDynA1, ModParamsA1.paramIconsA)
			creekBridge.ui.addStreetTypeIcons(streetConA1, ModParamsA1.paramIconsA)
			creekBridge.setConDescScriptFileAndParams(streetConA1, street_fileA1, ModParamsA1)
			creekBridge.addToRepository(street_fileA1, streetConA1, streetTemplateA1, streetDynA1)


			-- A2: same as A1 but with autobahn, so start the same
			ModParamsA2 = {
				paramPathA = setparPath,
				paramIconsA = setparIcons,
				streetwidthA = setparstreetwidth,
				Abn_PathA = AbnPath,
				HasPipeA = haspipeMod,
				TrackIconsA = TrackIconsA2,
			}

			-- Now add autobahn mod data...
			if hasAutobahnMod then
				ModParamsA2.streetwidthA = creekBridge.mergeTable(ModParamsA2.streetwidthA, Abnwidth)
				ModParamsA2.paramIconsA = creekBridge.mergeTable(ModParamsA2.paramIconsA, AutobahnIcons)
			end

			if hasAbBauMod then
				ModParamsA2.streetwidthA = creekBridge.mergeTable(ModParamsA2.streetwidthA, AbBauwidth)
				ModParamsA2.paramIconsA = creekBridge.mergeTable(ModParamsA2.paramIconsA, AbBauIcons)
			end

--			creekBridge.ui.addStreetTypeIcons(streetDynA2, ModParamsA2.paramIconsA)
			creekBridge.ui.addStreetTypeIcons(streetConA2, ModParamsA2.paramIconsA)
			creekBridge.setConDescScriptFileAndParams(streetConA2, street_fileA2, ModParamsA2)
			creekBridge.addToRepository(street_fileA2, streetConA2, streetTemplateA2, streetDynA2)
			
	end
}
end
