local creekBridge = {}
local creekBridgeUI = {}

-- Table merge, returning a new table, no deep copy
function creekBridge.mergeTable(t1, t2)
	local tn = {}
	for i = 1, #t1 do
		tn[i] = t1[i]
	end
	for i = 1, #t2 do
		tn[#tn+1] = t2[i]
	end
	return tn
end


-- Returns a ConstructionDesc, ConstructionTemplate and DynamicConstructionTemplate obj for a RAIL_STATION
function creekBridge.createConstructionRail(fileName, name, description, yearFrom, yearTo)
	local conDesc = api.type.ConstructionDesc.new()
	local conTemplate = api.type.ConstructionTemplate.new()
	local conDynamicTemplate = api.type.DynamicConstructionTemplate.new()

	conDesc.fileName = fileName
	conDesc.type = api.type.enum.ConstructionType.RAIL_STATION
	conDesc.description.name = name
	conDesc.description.description = description


	local mmAvailability = api.type.MetadataMap.Availability.new()
	mmAvailability.yearFrom = yearFrom
	mmAvailability.yearTo = yearTo

	conTemplate.availability = mmAvailability
	conTemplate.desc.name = name
	conTemplate.desc.description = description

	conDesc.categories = { "misc" }
	conDesc.order = 1213
	conDesc.skipCollision = true
--	conDesc.autoRemovable = false

	-- can't bind conTemplate and conDynamicTemplate now, because assigment would be a copy function, so empty objects would be set
	return conDesc, conTemplate, conDynamicTemplate
end

-- Returns a ConstructionDesc, ConstructionTemplate and DynamicConstructionTemplate obj for a STREET_STATION
function creekBridge.createConstructionStreet(fileName, name, description, yearFrom, yearTo)
	local conDesc = api.type.ConstructionDesc.new()
	local conTemplate = api.type.ConstructionTemplate.new()
	local conDynamicTemplate = api.type.DynamicConstructionTemplate.new()

	conDesc.fileName = fileName
	conDesc.type = api.type.enum.ConstructionType.STREET_CONSTRUCTION
	conDesc.description.name = name
	conDesc.description.description = description


	local mmAvailability = api.type.MetadataMap.Availability.new()
	mmAvailability.yearFrom = yearFrom
	mmAvailability.yearTo = yearTo

	conTemplate.availability = mmAvailability
	conTemplate.desc.name = name
	conTemplate.desc.description = description


	conDesc.categories = { "misc" }
	conDesc.order = 1213
	conDesc.skipCollision = true
	conDesc.autoRemovable = true

	-- can't bind conTemplate and conDynamicTemplate now, because assigment would be a copy function, so empty objects would be set
	return conDesc, conTemplate, conDynamicTemplate
end



-- Set all ConstructionDesc scripts and script parameters
function creekBridge.setConDescScriptFileAndParams(conDesc, file, ModParams)
	conDesc.updateScript.fileName = "construction/"..file..".updateFn"
	conDesc.updateScript.params = ModParams

	conDesc.preProcessScript.fileName = "construction/"..file..".preProcessFn"
	conDesc.preProcessScript.params = {}

	conDesc.upgradeScript.fileName = "construction/"..file..".upgradeFn"
	conDesc.upgradeScript.params = ModParams

	conDesc.createTemplateScript.fileName = "construction/"..file..".createTemplateFn"
	conDesc.createTemplateScript.params = ModParams
end

-- Finally insert a triple to the constructoion repository
function creekBridge.addToRepository(file, conDesc, conTemplate, conDynamicTemplate)
	-- note we have to set the conTemplate and conDynamicTemplate now,
	-- because TPF2 does copy on assigment
	conTemplate.data = conDynamicTemplate
	conDesc.constructionTemplates[1] = conTemplate
	api.res.constructionRep.add(file, conDesc, true)
end

-- ---------------------
-- UI Functions
-- most functions need atleast a ConstructionDesc or dynamicConstructionTemplate as object
-- ConstructionDesc = parameter shown in configuration mode aswell
-- dynamicConstructionTemplate = only when first build
-- ---------------------
function creekBridgeUI.addNumberOfBridges(objWithParams,strNumb)
	local sparam = api.type.ScriptParam.new()

	sparam.key = "bridgeNumC"
	sparam.name = _("Number of bridges")
	sparam.uiType = 0 --"BUTTON"
	sparam.values = strNumb
	if (objWithParams ~= nil) then
		objWithParams.params[#objWithParams.params+1] = sparam
	end
	return sparam
end

function creekBridgeUI.addBridgeSpan(objWithParams)
	local sparam = api.type.ScriptParam.new()

	sparam.key = "spanC"
	sparam.name = _("Bridge span")
	sparam.uiType = 0 --"BUTTON"
	sparam.values = { 
	   ("1m"), ("2m"), ("3m"), ("4.5m"), ("6m")}
	if (objWithParams ~= nil) then
		objWithParams.params[#objWithParams.params+1] = sparam
	end
	return sparam
end

function creekBridgeUI.addSpanX2(objWithParams)
	local sparam = api.type.ScriptParam.new()

	sparam.key = "spanX2C"
	sparam.name = _("x2")
	sparam.uiType = 0 --"BUTTON"
	sparam.values = { 
	   ("x1"), ("x2"),}
	if (objWithParams ~= nil) then
		objWithParams.params[#objWithParams.params+1] = sparam
	end
	return sparam
end


function creekBridgeUI.addClimate(objWithParams, climateIcons)
	local sparam = api.type.ScriptParam.new()

	sparam.key = "climateC"
	sparam.name = _("Climate")
	sparam.uiType = 3--"ICON_BUTTON"
	sparam.values = climateIcons
	if (objWithParams ~= nil) then
		objWithParams.params[#objWithParams.params+1] = sparam
	end
	return sparam
end

function creekBridgeUI.addNumberOfPipes(objWithParams)
	local sparam = api.type.ScriptParam.new()

	sparam.key = "pipeC"
	sparam.name = _("Pipe")
	sparam.uiType = 0 --"BUTTON"
	sparam.values = { 
					("0"),("1"),("2"),("3"),("4"),}
	if (objWithParams ~= nil) then
		objWithParams.params[#objWithParams.params+1] = sparam
	end
	return sparam
end


function creekBridgeUI.addNumberOfTracks(objWithParams)
	local sparam = api.type.ScriptParam.new()

	sparam.key = "trackNumC"
	sparam.name = _("Number of tracks")
	sparam.uiType = 0 --"BUTTON"
	sparam.values = {
		_("1"),_("2"),_("3"),_("4"),_("5"),_("6"),_("7"),_("8"),_("9"),_("10"),
	}
	if (objWithParams ~= nil) then
		objWithParams.params[#objWithParams.params+1] = sparam
	end
	return sparam
end

function creekBridgeUI.addTrackType(objWithParams,TrackIcons)
	local sparam = api.type.ScriptParam.new()
	sparam.key = "tracktypeC"
	sparam.name = _("Track type")
	sparam.uiType = 3--"ICON_BUTTON"
	sparam.values = TrackIcons   
	sparam.defaultIndex = 0
-- controls if highspeed tracks can be build
	sparam.yearFrom = 1925
	sparam.yearTo = 0

	if (objWithParams ~= nil) then
		objWithParams.params[#objWithParams.params+1] = sparam
	end
	return sparam
end

function creekBridgeUI.addCatenary(objWithParams)
	local sparam = api.type.ScriptParam.new()
	sparam.key = "catenaryC"
	sparam.name = _("Catenary")
	sparam.uiType = 0 --"BUTTON"
	sparam.values = {_("No"),_("Yes") }
	sparam.defaultIndex = 1
-- controls if catenary can be build
	sparam.yearFrom = 1910
	sparam.yearTo = 0

	if (objWithParams ~= nil) then
		objWithParams.params[#objWithParams.params+1] = sparam
	end
	return sparam
end

function creekBridgeUI.addRailing(objWithParams)
	local sparam = api.type.ScriptParam.new()
	sparam.key = "RailingC"
	sparam.name = _("Railing")
	sparam.uiType = 0 --"BUTTON"
	sparam.values = {_("No"),_("Yes") }
--	sparam.defaultIndex = 0
-- controls if catenary can be build
--	sparam.yearFrom = 1910
--	sparam.yearTo = 0

	if (objWithParams ~= nil) then
		objWithParams.params[#objWithParams.params+1] = sparam
	end
	return sparam
end

function creekBridgeUI.addPole(objWithParams)
	local sparam = api.type.ScriptParam.new()
	sparam.key = "PoleC"
	sparam.name = _("Extra Power Pole")
	sparam.uiType = 0 --"BUTTON"
	sparam.values = {_("None"),_("First"),_("End"),_("Both") }
	sparam.defaultIndex = 0
-- controls if catenary can be build
	sparam.yearFrom = 1910
	sparam.yearTo = 0

	if (objWithParams ~= nil) then
		objWithParams.params[#objWithParams.params+1] = sparam
	end
	return sparam
end


function creekBridgeUI.addStreetTypeIcons(objWithParams, icons)
	local sparam = api.type.ScriptParam.new()
	sparam.key = "streettypeC"
	sparam.name = _("Street type")
	sparam.uiType = 3--"ICON_BUTTON"
	sparam.values = icons
	sparam.defaultIndex = 0

	if (objWithParams ~= nil) then
		objWithParams.params[#objWithParams.params+1] = sparam
	end
	return sparam
end

function creekBridgeUI.addHeight(objWithParams)
	local sparam = api.type.ScriptParam.new()

	sparam.key = "heightC"
	sparam.name = _("Height")
	sparam.uiType = 0 --"BUTTON"
	sparam.values = {
		_("0"),_("0.5"),_("1"),_("1.5"),_("2"),_("2.5"),_("3"),_("3.5"),_("4"),_("4.5"),_("5"),
	}
	sparam.defaultIndex = 0
	if (objWithParams ~= nil) then
		objWithParams.params[#objWithParams.params+1] = sparam
	end
	return sparam
end

function creekBridgeUI.addSignHeight(objWithParams)
	local sparam = api.type.ScriptParam.new()

	sparam.key = "signHeightC"
	sparam.name = _("-/+")
	sparam.uiType = 0 --"BUTTON"
	sparam.values = {
		_("-"),_("+"),
	}
	sparam.defaultIndex = 1
	if (objWithParams ~= nil) then
		objWithParams.params[#objWithParams.params+1] = sparam
	end
	return sparam
end

function creekBridgeUI.addWaterHeight(objWithParams)
	local sparam = api.type.ScriptParam.new()

	sparam.key = "WaterHeightC"
	sparam.name = _("Water level")
	sparam.uiType = 0 --"BUTTON"
	sparam.values = {
		_("7"),_("6.5"),_("6"),_("5.5"),_("5"),_("4.5"),_("4"),_("3.5"),_("3"),_("2.5"),
	}
	sparam.defaultIndex = 5
	if (objWithParams ~= nil) then
		objWithParams.params[#objWithParams.params+1] = sparam
	end
	return sparam
end






creekBridge.ui = creekBridgeUI
return creekBridge