local bridgeutil = require "bridgeutil"
local ModOrder = 5

function data()
	
	return {
		name = _("GiBr_iL"),

		yearFrom = 1875,
		yearTo = 0,

		carriers = { "RAIL" },
	
		speedLimit = 200.0 / 3.6,
		
		pillarLen = 100,
		
		pillarMinDist = 6.0,
		pillarMaxDist = 132.0,
		pillarTargetDist = 48.0,

		cost = 450,		
		
		updateFn = function(params)
			local result = {
				railingModels = {},
				pillarModels = {}
			}
				
			-- Pillars
			for i, height in ipairs(params.pillarHeights) do
				table.insert(result.pillarModels, {})
			end
			
			-- Railing
			for i, interval in ipairs(params.railingIntervals) do
				-- init values
				
				local scaleZ = 1.0  -- scaling in z-axis
				
				local intervalLength = interval.length
				local intervalSegmentsNum = math.ceil(intervalLength / 5.95)
				local intervalSegmentsWidth = intervalLength / intervalSegmentsNum
				local scaleX = intervalSegmentsWidth / 5.95
				local offsetX = intervalSegmentsWidth / 2
				
				-- calc railing border offsets
				local offsetMin = interval.lanes[1].offset
				local offsetMax = interval.lanes[#interval.lanes].offset
				local offset = params.railingWidth - (offsetMax - offsetMin) - 2
				
				local rowWidth = offsetMax - offsetMin
				local rowSegmentsNumber = math.floor(rowWidth / 4)
				local rowSegmentWidth = rowWidth / rowSegmentsNumber
				local scaleY = rowSegmentWidth / 4
				local offsetY = offsetMin + rowSegmentWidth / 2
				
				local railingModels = {}
				for segment = 1, intervalSegmentsNum do
					local row = {
						{
							id = "bridge/rail/gittergraubruecke_il_A.mdl",
							transf = {scaleX, 0, 0, 0, 0, 1, 0, 0, 0, 0, scaleZ, 0, offsetX, offsetMin - offset, 0, 1}
						},
						{
							id = "bridge/rail/gittergraubruecke_il_A.mdl",
							transf = {-scaleX, 0, 0, 0, 0, -1, 0, 0, 0, 0, scaleZ, 0, offsetX, offsetMax + offset, 0, 1}
						},
					}
					
					for rowSegment = 1, rowSegmentsNumber do
						table.insert(
							row,
							{
								id = "bridge/rail/gittergraubruecke_il_B.mdl",
								transf = {scaleX, 0, 0, 0, 0, scaleY, 0, 0, 0, 0, scaleZ, 0, offsetX, offsetY + ( rowSegmentWidth * ( rowSegment - 1)) , 0, 1}
							}
						)
					end
					
					table.insert(railingModels, row)
					offsetX = offsetX + intervalSegmentsWidth
				end
				
				
				
				table.insert(result.railingModels, railingModels)
			end
			
			return result
		end
	}
end
