local vec2 = { }

function vec2.add(a, b)
	return { a[1] + b[1], a[2] + b[2] }
end

function vec2.sub(a, b)
	return { a[1] - b[1], a[2] - b[2] }
end

function vec2.mul(f, v)
	return { f * v[1], f * v[2] }
end

function vec2.dot(a, b)
	return a[1] * b[1] + a[2] * b[2];
end

function vec2.cross(a, b)
	return a[1] * b[2] - a[2] * b[1];
end

function vec2.equals(a,b)
	return a[1] == b[1] and a[2] == b[2]
end

function vec2.length(v)
	return math.sqrt(vec2.dot(v, v))
end

function vec2.lengthSqared(v)
	return vec2.dot(v, v)
end

function vec2.distance(a, b)
	return vec2.length(vec2.sub(a, b))
end

function vec2.distanceSquared(a, b)
	return vec2.lengthSqared(vec2.sub(a, b))
end

function vec2.normalize(v)
	return vec2.mul(1.0 / vec2.length(v), v)
end

function vec2.angle(a,b)
	return math.atan2( a[1] * b[2] - b[1] * a[2], a[1] * b[1] + a[2] * b[2] );	
end

return vec2