local powerlines = require "snowball/powerline/main"

local config = {}

config.powerlines = {
    snowball_powerline_power = {
        {
			model = "asset/snowball/powerline/snowball_powerline_power_flat.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {
				--Eingehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{6.21317, 0, 0, 0.2},
				{5.97972, 0, -0.85608, 0.2},
				{5.97972, 0, 0.85608, 0.2},
			},
			configurationB = {
				--Ausgehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{6.21317, 0, 0, 0.2},
				{5.97972, 0, -0.85608, 0.2},
				{5.97972, 0, 0.85608, 0.2},
			},
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_power_zigzag_1.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {
				{5.91631, -0.22627, -0.26812, 0.2},
			},
			configurationB = {
				{5.91631, -0.22627, -0.26812, 0.2},
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_power_zigzag_3.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {
				{5.91631, -0.22627, -0.26812, 0.2},
				{5.61657, 0.22627, 0.26812, 0.2},
				{5.31682, -0.22627, -0.26812, 0.2},
			},
			configurationB = {
				{5.91631, -0.22627, -0.26812, 0.2},
				{5.61657, 0.22627, 0.26812, 0.2},
				{5.31682, -0.22627, -0.26812, 0.2},
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_power_zigzag_4.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {
				{5.91631, -0.22627, -0.26812, 0.2},
				{5.61657, 0.22627, 0.26812, 0.2},
				{5.31682, -0.22627, -0.26812, 0.2},
				{5.01708, 0.22627, 0.26812, 0.2},
			},
			configurationB = {
				{5.91631, -0.22627, -0.26812, 0.2},
				{5.61657, 0.22627, 0.26812, 0.2},
				{5.31682, -0.22627, -0.26812, 0.2},
				{5.01708, 0.22627, 0.26812, 0.2},
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_power_roof_1S.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {
				{2.12831, 0, 0.15668, 0.2},
				{2.12831, 0, 0.55778, 0.2},
				{1.47982, 0, 0.15668, 0.2},
				{1.47982, 0, 0.55778, 0.2},
			},
			configurationB = {
				{2.12831, 0, 0.15668, 0.2},
				{2.12831, 0, 0.55778, 0.2},
				{1.47982, 0, 0.15668, 0.2},
				{1.47982, 0, 0.55778, 0.2},
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_power_roof_2S.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {
				{2.17874, 0, -0.55778, 0.2},
				{2.17874, 0, 0.55778, 0.2},
				{1.47982, 0, -0.55778, 0.2},
				{1.47982, 0, 0.55778, 0.2},
			},
			configurationB = {
				{2.17874, 0, -0.55778, 0.2},
				{2.17874, 0, 0.55778, 0.2},
				{1.47982, 0, -0.55778, 0.2},
				{1.47982, 0, 0.55778, 0.2},
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_power_roof_2SN.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {
				{1.97708, 0, -0.35682, 0.2},
				{1.97708, 0, 0.35682, 0.2},
				{1.47982, 0, -0.35682, 0.2},
				{1.47982, 0, 0.35682, 0.2},
			},
			configurationB = {
				{1.97708, 0, -0.35682, 0.2},
				{1.97708, 0, 0.35682, 0.2},
				{1.47982, 0, -0.35682, 0.2},
				{1.47982, 0, 0.35682, 0.2},
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_power_trafohaus.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {
				{6.43297, -2.11633, 0, 0.2},
				{6.43297, -2.11633, -0.63034, 0.2},
				{6.43297, -2.11633, 0.63034, 0.2},
			},
			configurationB = {
				{6.43297, 2.11633, 0, 0.2},
				{6.43297, 2.11633, -0.63034, 0.2},
				{6.43297, 2.11633, 0.63034, 0.2},
			}
		},
    },
    snowball_powerline_donau = {
        {
			model = "asset/snowball/powerline/snowball_powerline_donau_1R.mdl",
			width = 24,
			offset = {0,0,0},
			configurationA = {
				--Eingehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{29.29228, 0.0, 0, 0.4},
				{20.65996, -3.64857, 0, 1.1},
				{20.65996, 3.64857, 0, 1.1},
				{20.65996, -6.65164, 0, 1.1},
				{20.65996, 6.65164, 0, 1.1},
			},
			configurationB = {
				--Ausgehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{29.29228, 0.0, 0, 0.4},
				{20.65996, -3.64857, 0, 1.1},
				{20.65996, 3.64857, 0, 1.1},
				{20.65996, -6.65164, 0, 1.1},
				{20.65996, 6.65164, 0, 1.1},
			},
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_donau_2R.mdl",
			width = 24,
			offset = {0,0,0},
			configurationA = {
				{29.29228, 0.0, 0, 0.4},
				{20.65996, -6.65164, 0, 1.1},
				{20.65996, 6.65164, 0, 1.1},
				{14.20756, -9.33421, 0, 1.1},
				{14.20756, 9.33421, 0, 1.1},
				{14.20756, -5.09941, 0, 1.1},
				{14.20756, 5.09941, 0, 1.1},
			},
			configurationB = {
				{29.29228, 0.0, 0, 0.4},
				{20.65996, -6.65164, 0, 1.1},
				{20.65996, 6.65164, 0, 1.1},
				{14.20756, -9.33421, 0, 1.1},
				{14.20756, 9.33421, 0, 1.1},
				{14.20756, -5.09941, 0, 1.1},
				{14.20756, 5.09941, 0, 1.1},
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_donau_3R.mdl",
			width = 24,
			offset = {0,0,0},
			configurationA = {
				{35.00000, 0.0, 0, 0.4},
				
				{26.40537, -4.61736, 0, 1.1},
				{26.40537, 4.61736, 0, 1.1},
				{26.40537, -8.12103, 0, 1.1},
				{26.40537, 8.12103, 0, 1.1},
				
				{20.65996, -7.26124, 0, 1.1},
				{20.65996, 7.26124, 0, 1.1},
				
				{14.20756, -5.73123, 0, 1.1},
				{14.20756, 5.73123, 0, 1.1},
				{14.20756, -9.93443, 0, 1.1},
				{14.20756, 9.93443, 0, 1.1},
			},
			configurationB = {
				{35.00000, 0.0, 0, 0.4},
				
				{26.40537, -4.61736, 0, 1.1},
				{26.40537, 4.61736, 0, 1.1},
				{26.40537, -8.12103, 0, 1.1},
				{26.40537, 8.12103, 0, 1.1},
				
				{20.65996, -7.26124, 0, 1.1},
				{20.65996, 7.26124, 0, 1.1},
				
				{14.20756, -5.73123, 0, 1.1},
				{14.20756, 5.73123, 0, 1.1},
				{14.20756, -9.93443, 0, 1.1},
				{14.20756, 9.93443, 0, 1.1},
			}
		},
    },
    snowball_powerline_telegraph = {
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_1R_AL.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {           
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 
			},           
			configurationB = {           
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_1R.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {           
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 
			},           
			configurationB = {           
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_1R_B.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {           
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 
			},           
			configurationB = {           
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_1R_AR.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {           
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 
			},           
			configurationB = {           
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 
			}
		},
		
		
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_2RS_AL.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {         
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
			},           
			configurationB = {         
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_2RS.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {         
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
			},           
			configurationB = {         
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_2RS_B.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {         
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
			},           
			configurationB = {         
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_2RS_AR.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {         
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
			},           
			configurationB = {         
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
			}
		},
        
		
		{
			model = "asset/snowball/powerline/snowball_powerline_telegraph_2RB_AL.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {          
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 

				{6.768, 0, -0.32, 0.2},
				{6.768, 0, 0.32, 0.2},  
				{6.704, 0, -0.592, 0.2},
				{6.704, 0, 0.592, 0.2},
				{6.768, 0, -0.856, 0.2},
				{6.768, 0, 0.856, 0.2},
				{6.608, 0, -1.26627, 0.2}, 
				{6.608, 0, 1.26627, 0.2}, 
			},           
			configurationB = {          
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 

				{6.768, 0, -0.32, 0.2},
				{6.768, 0, 0.32, 0.2},  
				{6.704, 0, -0.592, 0.2},
				{6.704, 0, 0.592, 0.2},
				{6.768, 0, -0.856, 0.2},
				{6.768, 0, 0.856, 0.2},
				{6.608, 0, -1.26627, 0.2}, 
				{6.608, 0, 1.26627, 0.2}, 
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_2RB.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {        
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 

				{6.768, 0, -0.32, 0.2},
				{6.768, 0, 0.32, 0.2},  
				{6.704, 0, -0.592, 0.2},
				{6.704, 0, 0.592, 0.2},
				{6.768, 0, -0.856, 0.2},
				{6.768, 0, 0.856, 0.2},
				{6.608, 0, -1.26627, 0.2}, 
				{6.608, 0, 1.26627, 0.2}, 
			},           
			configurationB = {          
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 

				{6.768, 0, -0.32, 0.2},
				{6.768, 0, 0.32, 0.2},  
				{6.704, 0, -0.592, 0.2},
				{6.704, 0, 0.592, 0.2},
				{6.768, 0, -0.856, 0.2},
				{6.768, 0, 0.856, 0.2},
				{6.608, 0, -1.26627, 0.2}, 
				{6.608, 0, 1.26627, 0.2}, 
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_2RB_B.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {        
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 

				{6.768, 0, -0.32, 0.2},
				{6.768, 0, 0.32, 0.2},  
				{6.704, 0, -0.592, 0.2},
				{6.704, 0, 0.592, 0.2},
				{6.768, 0, -0.856, 0.2},
				{6.768, 0, 0.856, 0.2},
				{6.608, 0, -1.26627, 0.2}, 
				{6.608, 0, 1.26627, 0.2}, 
			},           
			configurationB = {          
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 

				{6.768, 0, -0.32, 0.2},
				{6.768, 0, 0.32, 0.2},  
				{6.704, 0, -0.592, 0.2},
				{6.704, 0, 0.592, 0.2},
				{6.768, 0, -0.856, 0.2},
				{6.768, 0, 0.856, 0.2},
				{6.608, 0, -1.26627, 0.2}, 
				{6.608, 0, 1.26627, 0.2}, 
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_2RB_AR.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {      
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 

				{6.768, 0, -0.32, 0.2},
				{6.768, 0, 0.32, 0.2},  
				{6.704, 0, -0.592, 0.2},
				{6.704, 0, 0.592, 0.2},
				{6.768, 0, -0.856, 0.2},
				{6.768, 0, 0.856, 0.2},
				{6.608, 0, -1.26627, 0.2}, 
				{6.608, 0, 1.26627, 0.2}, 
			},           
			configurationB = {          
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.408, 0, -0.856, 0.2},
				{7.408, 0, 0.856, 0.2},
				{7.248, 0, -1.26627, 0.2}, 
				{7.248, 0, 1.26627, 0.2}, 

				{6.768, 0, -0.32, 0.2},
				{6.768, 0, 0.32, 0.2},  
				{6.704, 0, -0.592, 0.2},
				{6.704, 0, 0.592, 0.2},
				{6.768, 0, -0.856, 0.2},
				{6.768, 0, 0.856, 0.2},
				{6.608, 0, -1.26627, 0.2}, 
				{6.608, 0, 1.26627, 0.2}, 
			}
		},
		
		
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_3R_AL.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {        
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.248, 0, -0.76628, 0.2}, 
				{7.248, 0, 0.76628, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
				{7.248-0.64, 0, -0.76628, 0.2}, 
				{7.248-0.64, 0, 0.76628, 0.2}, 
				
				{7.408-1.28, 0, -0.32, 0.2},  
				{7.408-1.28, 0, 0.32, 0.2},    
				{7.344-1.28, 0, -0.592, 0.2},   
				{7.344-1.28, 0, 0.592, 0.2}, 
			},           
			configurationB = {        
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.248, 0, -0.76628, 0.2}, 
				{7.248, 0, 0.76628, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
				{7.248-0.64, 0, -0.76628, 0.2}, 
				{7.248-0.64, 0, 0.76628, 0.2}, 
				
				{7.408-1.28, 0, -0.32, 0.2},  
				{7.408-1.28, 0, 0.32, 0.2},    
				{7.344-1.28, 0, -0.592, 0.2},   
				{7.344-1.28, 0, 0.592, 0.2}, 
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_3R.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {     
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.248, 0, -0.76628, 0.2}, 
				{7.248, 0, 0.76628, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
				{7.248-0.64, 0, -0.76628, 0.2}, 
				{7.248-0.64, 0, 0.76628, 0.2}, 
				
				{7.408-1.28, 0, -0.32, 0.2},  
				{7.408-1.28, 0, 0.32, 0.2},    
				{7.344-1.28, 0, -0.592, 0.2},   
				{7.344-1.28, 0, 0.592, 0.2}, 
			},           
			configurationB = {        
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.248, 0, -0.76628, 0.2}, 
				{7.248, 0, 0.76628, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
				{7.248-0.64, 0, -0.76628, 0.2}, 
				{7.248-0.64, 0, 0.76628, 0.2}, 
				
				{7.408-1.28, 0, -0.32, 0.2},  
				{7.408-1.28, 0, 0.32, 0.2},    
				{7.344-1.28, 0, -0.592, 0.2},   
				{7.344-1.28, 0, 0.592, 0.2}, 
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_3R_B.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {        
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.248, 0, -0.76628, 0.2}, 
				{7.248, 0, 0.76628, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
				{7.248-0.64, 0, -0.76628, 0.2}, 
				{7.248-0.64, 0, 0.76628, 0.2}, 
				
				{7.408-1.28, 0, -0.32, 0.2},  
				{7.408-1.28, 0, 0.32, 0.2},    
				{7.344-1.28, 0, -0.592, 0.2},   
				{7.344-1.28, 0, 0.592, 0.2}, 
			},           
			configurationB = {        
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.248, 0, -0.76628, 0.2}, 
				{7.248, 0, 0.76628, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
				{7.248-0.64, 0, -0.76628, 0.2}, 
				{7.248-0.64, 0, 0.76628, 0.2}, 
				
				{7.408-1.28, 0, -0.32, 0.2},  
				{7.408-1.28, 0, 0.32, 0.2},    
				{7.344-1.28, 0, -0.592, 0.2},   
				{7.344-1.28, 0, 0.592, 0.2}, 
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_3R_AR.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {        
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.248, 0, -0.76628, 0.2}, 
				{7.248, 0, 0.76628, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
				{7.248-0.64, 0, -0.76628, 0.2}, 
				{7.248-0.64, 0, 0.76628, 0.2}, 
				
				{7.408-1.28, 0, -0.32, 0.2},  
				{7.408-1.28, 0, 0.32, 0.2},    
				{7.344-1.28, 0, -0.592, 0.2},   
				{7.344-1.28, 0, 0.592, 0.2}, 
			},           
			configurationB = {        
				{7.408, 0, -0.32, 0.2},  
				{7.408, 0, 0.32, 0.2},    
				{7.344, 0, -0.592, 0.2},   
				{7.344, 0, 0.592, 0.2}, 
				{7.248, 0, -0.76628, 0.2}, 
				{7.248, 0, 0.76628, 0.2}, 
				
				{7.408-0.64, 0, -0.32, 0.2},  
				{7.408-0.64, 0, 0.32, 0.2},    
				{7.344-0.64, 0, -0.592, 0.2},   
				{7.344-0.64, 0, 0.592, 0.2}, 
				{7.248-0.64, 0, -0.76628, 0.2}, 
				{7.248-0.64, 0, 0.76628, 0.2}, 
				
				{7.408-1.28, 0, -0.32, 0.2},  
				{7.408-1.28, 0, 0.32, 0.2},    
				{7.344-1.28, 0, -0.592, 0.2},   
				{7.344-1.28, 0, 0.592, 0.2}, 
			}
		},
		
		
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_DP_AL.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {  
				{7.344, 0, 0, 0.2},
				{7.408, 0, -0.244, 0.2},
				{7.408, 0, 0.244, 0.2},
				{7.344, 0, -0.508, 0.2},
				{7.344, 0, 0.508, 0.2},
				{7.408, 0, -0.78, 0.2},
				{7.408, 0, 0.78, 0.2},
				
				{7.344-0.64, 0, 0, 0.2},
				{7.408-0.64, 0, -0.244, 0.2},
				{7.408-0.64, 0, 0.244, 0.2},
				{7.344-0.64, 0, -0.508, 0.2},
				{7.344-0.64, 0, 0.508, 0.2},
				{7.408-0.64, 0, -0.78, 0.2},
				{7.408-0.64, 0, 0.78, 0.2},
				
				{7.408-1.28, 0, -0.244, 0.2},
				{7.408-1.28, 0, 0.244, 0.2},
				{7.344-1.28, 0, -0.508, 0.2},
				{7.344-1.28, 0, 0.508, 0.2},
				{7.408-1.28, 0, -0.78, 0.2},
				{7.408-1.28, 0, 0.78, 0.2},

				{7.408, 0, -1.42, 0.2},
				{7.408, 0, 1.42, 0.2},
				{7.344, 0, -1.69, 0.2},
				{7.344, 0, 1.69, 0.2},
				
				{7.408-0.64, 0, -1.42, 0.2},
				{7.408-0.64, 0, 1.42, 0.2},
				{7.344-0.64, 0, -1.69, 0.2},
				{7.344-0.64, 0, 1.69, 0.2},
				
				{7.408-1.28, 0, -1.42, 0.2},
				{7.408-1.28, 0, 1.42, 0.2},
				{7.344-1.28, 0, -1.69, 0.2},
				{7.344-1.28, 0, 1.69, 0.2},
			},           
			configurationB = {  
				{7.344, 0, 0, 0.2},
				{7.408, 0, -0.244, 0.2},
				{7.408, 0, 0.244, 0.2},
				{7.344, 0, -0.508, 0.2},
				{7.344, 0, 0.508, 0.2},
				{7.408, 0, -0.78, 0.2},
				{7.408, 0, 0.78, 0.2},
				
				{7.344-0.64, 0, 0, 0.2},
				{7.408-0.64, 0, -0.244, 0.2},
				{7.408-0.64, 0, 0.244, 0.2},
				{7.344-0.64, 0, -0.508, 0.2},
				{7.344-0.64, 0, 0.508, 0.2},
				{7.408-0.64, 0, -0.78, 0.2},
				{7.408-0.64, 0, 0.78, 0.2},
				
				{7.408-1.28, 0, -0.244, 0.2},
				{7.408-1.28, 0, 0.244, 0.2},
				{7.344-1.28, 0, -0.508, 0.2},
				{7.344-1.28, 0, 0.508, 0.2},
				{7.408-1.28, 0, -0.78, 0.2},
				{7.408-1.28, 0, 0.78, 0.2},

				{7.408, 0, -1.42, 0.2},
				{7.408, 0, 1.42, 0.2},
				{7.344, 0, -1.69, 0.2},
				{7.344, 0, 1.69, 0.2},
				
				{7.408-0.64, 0, -1.42, 0.2},
				{7.408-0.64, 0, 1.42, 0.2},
				{7.344-0.64, 0, -1.69, 0.2},
				{7.344-0.64, 0, 1.69, 0.2},
				
				{7.408-1.28, 0, -1.42, 0.2},
				{7.408-1.28, 0, 1.42, 0.2},
				{7.344-1.28, 0, -1.69, 0.2},
				{7.344-1.28, 0, 1.69, 0.2},
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_DP.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {  
				{7.344, 0, 0, 0.2},
				{7.408, 0, -0.244, 0.2},
				{7.408, 0, 0.244, 0.2},
				{7.344, 0, -0.508, 0.2},
				{7.344, 0, 0.508, 0.2},
				{7.408, 0, -0.78, 0.2},
				{7.408, 0, 0.78, 0.2},
				
				{7.344-0.64, 0, 0, 0.2},
				{7.408-0.64, 0, -0.244, 0.2},
				{7.408-0.64, 0, 0.244, 0.2},
				{7.344-0.64, 0, -0.508, 0.2},
				{7.344-0.64, 0, 0.508, 0.2},
				{7.408-0.64, 0, -0.78, 0.2},
				{7.408-0.64, 0, 0.78, 0.2},
				
				{7.408-1.28, 0, -0.244, 0.2},
				{7.408-1.28, 0, 0.244, 0.2},
				{7.344-1.28, 0, -0.508, 0.2},
				{7.344-1.28, 0, 0.508, 0.2},
				{7.408-1.28, 0, -0.78, 0.2},
				{7.408-1.28, 0, 0.78, 0.2},

				{7.408, 0, -1.42, 0.2},
				{7.408, 0, 1.42, 0.2},
				{7.344, 0, -1.69, 0.2},
				{7.344, 0, 1.69, 0.2},
				
				{7.408-0.64, 0, -1.42, 0.2},
				{7.408-0.64, 0, 1.42, 0.2},
				{7.344-0.64, 0, -1.69, 0.2},
				{7.344-0.64, 0, 1.69, 0.2},
				
				{7.408-1.28, 0, -1.42, 0.2},
				{7.408-1.28, 0, 1.42, 0.2},
				{7.344-1.28, 0, -1.69, 0.2},
				{7.344-1.28, 0, 1.69, 0.2},
			},           
			configurationB = {  
				{7.344, 0, 0, 0.2},
				{7.408, 0, -0.244, 0.2},
				{7.408, 0, 0.244, 0.2},
				{7.344, 0, -0.508, 0.2},
				{7.344, 0, 0.508, 0.2},
				{7.408, 0, -0.78, 0.2},
				{7.408, 0, 0.78, 0.2},
				
				{7.344-0.64, 0, 0, 0.2},
				{7.408-0.64, 0, -0.244, 0.2},
				{7.408-0.64, 0, 0.244, 0.2},
				{7.344-0.64, 0, -0.508, 0.2},
				{7.344-0.64, 0, 0.508, 0.2},
				{7.408-0.64, 0, -0.78, 0.2},
				{7.408-0.64, 0, 0.78, 0.2},
				
				{7.408-1.28, 0, -0.244, 0.2},
				{7.408-1.28, 0, 0.244, 0.2},
				{7.344-1.28, 0, -0.508, 0.2},
				{7.344-1.28, 0, 0.508, 0.2},
				{7.408-1.28, 0, -0.78, 0.2},
				{7.408-1.28, 0, 0.78, 0.2},

				{7.408, 0, -1.42, 0.2},
				{7.408, 0, 1.42, 0.2},
				{7.344, 0, -1.69, 0.2},
				{7.344, 0, 1.69, 0.2},
				
				{7.408-0.64, 0, -1.42, 0.2},
				{7.408-0.64, 0, 1.42, 0.2},
				{7.344-0.64, 0, -1.69, 0.2},
				{7.344-0.64, 0, 1.69, 0.2},
				
				{7.408-1.28, 0, -1.42, 0.2},
				{7.408-1.28, 0, 1.42, 0.2},
				{7.344-1.28, 0, -1.69, 0.2},
				{7.344-1.28, 0, 1.69, 0.2},
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_DP_B.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {  
				{7.344, 0, 0, 0.2},
				{7.408, 0, -0.244, 0.2},
				{7.408, 0, 0.244, 0.2},
				{7.344, 0, -0.508, 0.2},
				{7.344, 0, 0.508, 0.2},
				{7.408, 0, -0.78, 0.2},
				{7.408, 0, 0.78, 0.2},
				
				{7.344-0.64, 0, 0, 0.2},
				{7.408-0.64, 0, -0.244, 0.2},
				{7.408-0.64, 0, 0.244, 0.2},
				{7.344-0.64, 0, -0.508, 0.2},
				{7.344-0.64, 0, 0.508, 0.2},
				{7.408-0.64, 0, -0.78, 0.2},
				{7.408-0.64, 0, 0.78, 0.2},
				
				{7.408-1.28, 0, -0.244, 0.2},
				{7.408-1.28, 0, 0.244, 0.2},
				{7.344-1.28, 0, -0.508, 0.2},
				{7.344-1.28, 0, 0.508, 0.2},
				{7.408-1.28, 0, -0.78, 0.2},
				{7.408-1.28, 0, 0.78, 0.2},

				{7.408, 0, -1.42, 0.2},
				{7.408, 0, 1.42, 0.2},
				{7.344, 0, -1.69, 0.2},
				{7.344, 0, 1.69, 0.2},
				
				{7.408-0.64, 0, -1.42, 0.2},
				{7.408-0.64, 0, 1.42, 0.2},
				{7.344-0.64, 0, -1.69, 0.2},
				{7.344-0.64, 0, 1.69, 0.2},
				
				{7.408-1.28, 0, -1.42, 0.2},
				{7.408-1.28, 0, 1.42, 0.2},
				{7.344-1.28, 0, -1.69, 0.2},
				{7.344-1.28, 0, 1.69, 0.2},
			},           
			configurationB = {  
				{7.344, 0, 0, 0.2},
				{7.408, 0, -0.244, 0.2},
				{7.408, 0, 0.244, 0.2},
				{7.344, 0, -0.508, 0.2},
				{7.344, 0, 0.508, 0.2},
				{7.408, 0, -0.78, 0.2},
				{7.408, 0, 0.78, 0.2},
				
				{7.344-0.64, 0, 0, 0.2},
				{7.408-0.64, 0, -0.244, 0.2},
				{7.408-0.64, 0, 0.244, 0.2},
				{7.344-0.64, 0, -0.508, 0.2},
				{7.344-0.64, 0, 0.508, 0.2},
				{7.408-0.64, 0, -0.78, 0.2},
				{7.408-0.64, 0, 0.78, 0.2},
				
				{7.408-1.28, 0, -0.244, 0.2},
				{7.408-1.28, 0, 0.244, 0.2},
				{7.344-1.28, 0, -0.508, 0.2},
				{7.344-1.28, 0, 0.508, 0.2},
				{7.408-1.28, 0, -0.78, 0.2},
				{7.408-1.28, 0, 0.78, 0.2},

				{7.408, 0, -1.42, 0.2},
				{7.408, 0, 1.42, 0.2},
				{7.344, 0, -1.69, 0.2},
				{7.344, 0, 1.69, 0.2},
				
				{7.408-0.64, 0, -1.42, 0.2},
				{7.408-0.64, 0, 1.42, 0.2},
				{7.344-0.64, 0, -1.69, 0.2},
				{7.344-0.64, 0, 1.69, 0.2},
				
				{7.408-1.28, 0, -1.42, 0.2},
				{7.408-1.28, 0, 1.42, 0.2},
				{7.344-1.28, 0, -1.69, 0.2},
				{7.344-1.28, 0, 1.69, 0.2},
			}
		},
        {
			model = "asset/snowball/powerline/snowball_powerline_telegraph_DP_AR.mdl",
			width = 3,
			offset = {0.5,0.5,0.5},
			configurationA = {  
				{7.344, 0, 0, 0.2},
				{7.408, 0, -0.244, 0.2},
				{7.408, 0, 0.244, 0.2},
				{7.344, 0, -0.508, 0.2},
				{7.344, 0, 0.508, 0.2},
				{7.408, 0, -0.78, 0.2},
				{7.408, 0, 0.78, 0.2},
				
				{7.344-0.64, 0, 0, 0.2},
				{7.408-0.64, 0, -0.244, 0.2},
				{7.408-0.64, 0, 0.244, 0.2},
				{7.344-0.64, 0, -0.508, 0.2},
				{7.344-0.64, 0, 0.508, 0.2},
				{7.408-0.64, 0, -0.78, 0.2},
				{7.408-0.64, 0, 0.78, 0.2},
				
				{7.408-1.28, 0, -0.244, 0.2},
				{7.408-1.28, 0, 0.244, 0.2},
				{7.344-1.28, 0, -0.508, 0.2},
				{7.344-1.28, 0, 0.508, 0.2},
				{7.408-1.28, 0, -0.78, 0.2},
				{7.408-1.28, 0, 0.78, 0.2},

				{7.408, 0, -1.42, 0.2},
				{7.408, 0, 1.42, 0.2},
				{7.344, 0, -1.69, 0.2},
				{7.344, 0, 1.69, 0.2},
				
				{7.408-0.64, 0, -1.42, 0.2},
				{7.408-0.64, 0, 1.42, 0.2},
				{7.344-0.64, 0, -1.69, 0.2},
				{7.344-0.64, 0, 1.69, 0.2},
				
				{7.408-1.28, 0, -1.42, 0.2},
				{7.408-1.28, 0, 1.42, 0.2},
				{7.344-1.28, 0, -1.69, 0.2},
				{7.344-1.28, 0, 1.69, 0.2},
			},           
			configurationB = {  
				{7.344, 0, 0, 0.2},
				{7.408, 0, -0.244, 0.2},
				{7.408, 0, 0.244, 0.2},
				{7.344, 0, -0.508, 0.2},
				{7.344, 0, 0.508, 0.2},
				{7.408, 0, -0.78, 0.2},
				{7.408, 0, 0.78, 0.2},
				
				{7.344-0.64, 0, 0, 0.2},
				{7.408-0.64, 0, -0.244, 0.2},
				{7.408-0.64, 0, 0.244, 0.2},
				{7.344-0.64, 0, -0.508, 0.2},
				{7.344-0.64, 0, 0.508, 0.2},
				{7.408-0.64, 0, -0.78, 0.2},
				{7.408-0.64, 0, 0.78, 0.2},
				
				{7.408-1.28, 0, -0.244, 0.2},
				{7.408-1.28, 0, 0.244, 0.2},
				{7.344-1.28, 0, -0.508, 0.2},
				{7.344-1.28, 0, 0.508, 0.2},
				{7.408-1.28, 0, -0.78, 0.2},
				{7.408-1.28, 0, 0.78, 0.2},

				{7.408, 0, -1.42, 0.2},
				{7.408, 0, 1.42, 0.2},
				{7.344, 0, -1.69, 0.2},
				{7.344, 0, 1.69, 0.2},
				
				{7.408-0.64, 0, -1.42, 0.2},
				{7.408-0.64, 0, 1.42, 0.2},
				{7.344-0.64, 0, -1.69, 0.2},
				{7.344-0.64, 0, 1.69, 0.2},
				
				{7.408-1.28, 0, -1.42, 0.2},
				{7.408-1.28, 0, 1.42, 0.2},
				{7.344-1.28, 0, -1.69, 0.2},
				{7.344-1.28, 0, 1.69, 0.2},
			}
		},
    },  
}

function config.load()

    local existingPowerlines = {}

    for id,powerline in pairs(powerlines.powerlines) do               
        existingPowerlines[id] = powerline      
    end

    powerlines.powerlines = {}

    for id,powerline in pairs(config.powerlines) do               
        powerlines.powerlines[id] = powerline      
    end

    for id,powerline in pairs(existingPowerlines) do               
        powerlines.powerlines[id] = powerline      
    end

    

end 

return config

