local transf = require "transf"

local vec2 = require "snowball/common/vec2_1"
local vec3 = require "snowball/common/vec3_1"
local vec4 = require "snowball/common/vec4_1"
local mat3 = require "snowball/common/mat3_1"
local polygon = require "snowball/powerline/polygon"

local powerlines = {}

powerlines.modePlanning = 0
powerlines.modeBuild = 1
powerlines.modeReset = 2

local tensions = { 0.00025, 0.0005, 0.001 }

powerlines.powerlines = {}

function powerlines.createParams(types, offsetCoeffs, fixtension)
    
    local params = {}
	
	if fixtension == nil then
		params[#params + 1] = {
			key = "snowball_powerlines_tension",
			name = _("snowball_powerlines_tension"),
			tooltip = _("snowball_powerlines_tension_tip"),
			values = {_("strong"), _("normal"), _("weak")},
			defaultIndex = 1
		}
	end
    
	params[#params + 1] = {
        key = "snowball_powerlines_type",
        name = _("snowball_powerlines_type"),
		tooltip = _("snowball_powerlines_type_tip"),
		uiType = "ICON_BUTTON",
        values = types,
        defaultIndex = 0
    }
	
	if offsetCoeffs[1] ~= 0 then
		local offsets = {}
		for i = -10, 10 do
			offsets[#offsets + 1] = tostring(i * offsetCoeffs[1])
		end
		
		params[#params + 1] = {
        key = "snowball_powerlines_offset_x",
		name = _("snowball_powerlines_offset_x"),
		tooltip = _("snowball_powerlines_offset_x_tip"),
		uiType = "SLIDER",
		values = offsets,
		defaultIndex = 10
		}
	end
	if offsetCoeffs[2] ~= 0 then
		local offsets = {}
		for i = -10, 10 do
			offsets[#offsets + 1] = tostring(i * offsetCoeffs[2])
		end
		
		params[#params + 1] = {
        key = "snowball_powerlines_offset_y",
		name = _("snowball_powerlines_offset_y"),
		tooltip = _("snowball_powerlines_offset_y_tip"),
		uiType = "SLIDER",
		values = offsets,
		defaultIndex = 10
		}
	end
	if offsetCoeffs[3] ~= 0 then
		local offsets = {}
		for i = -10, 10 do
			offsets[#offsets + 1] = tostring(i * offsetCoeffs[3])
		end
		
		params[#params + 1] = {
        key = "snowball_powerlines_offset_z",
		name = _("snowball_powerlines_offset_z"),
		tooltip = _("snowball_powerlines_offset_z_tip"),
		uiType = "SLIDER",
		values = offsets,
		defaultIndex = 10
		}
	end
	
    return params
end


function powerlines.buildGround(point, result)

    local p1 = vec3.add(point, {0.2, 0, 0})
    local p2 = vec3.add(point, {0, 0.2, 0})
    local p3 = vec3.add(point, {-0.2, 0, 0})
    local p4 = vec3.add(point, {0, -0.2, 0})

    result.groundFaces[#result.groundFaces + 1] = {
        face = {p1, p2, p3, p4},
        modes = {
            {
                type = "FILL",
                key = "tree_ground.lua"
            },            
        }
    }
end

function powerlines.buildSegment(point1, point2, model, modelTransform, result)
    local b2 = vec3.sub(point2, point1)
    local b3 = vec2.mul(2, vec2.normalize({b2[2], -b2[1]}))
    b3[3] = 0

    local affine = mat3.affine(b2, b3)

    local transform =
    transf.mul(        
        transf.new(
            vec4.new(affine[1][1], affine[2][1], affine[3][1], .0),
            vec4.new(affine[1][2], affine[2][2], affine[3][2], .0),
            vec4.new(affine[1][3], affine[2][3], affine[3][3], .0),
            vec4.new(point1[1], point1[2], point1[3], 1.0)
        ),
        modelTransform    
    )      

    result.models[#result.models + 1] = {
        id = model,
        transf = transform
    }
end

function powerlines.buildCable(transf1, transf2, offset1, offset2, configuration1, configuration2, model, tension, result)
    local thickness = configuration2[4]

    local a = vec3.add(transf1[4],mat3.transform(transf1,{configuration1[2] + offset1[2],configuration1[3] + offset1[3],configuration1[1] - offset1[1]}))
	local b = vec3.add(transf2[4],mat3.transform(transf2,{configuration2[2] + offset2[2],configuration2[3] + offset2[3],configuration2[1] - offset2[1]}))

    local d = vec2.length(vec2.sub(b, a))
	
	if d > 0.01 then
		local parabel = {tensions[tension], 0, -tensions[tension] * 0.25 * d * d}

		local segment_count = math.min(20, math.max(1, math.round(d / 10)))
		local segment_length = d / segment_count
		local cable = {}

		for j = 0, segment_count do
			local dx = j * segment_length
			local p = vec3.add(a, vec3.mul(dx / d, vec3.sub(b, a)))

			p[3] = p[3] + polygon.parabelPoint(parabel, dx - 0.5 * d)
			cable[#cable + 1] = p
		end

		local transf = {1, 0, 0, 0, 0, thickness, 0, 0, 0, 0, thickness, 0, 0, 0, 0, 1}

		for j = 1, #cable - 1 do
			local a = cable[j]
			local b = cable[j + 1]
			powerlines.buildSegment(a, b, model,transf, result)
		end
	end
end


function powerlines.build(new, previous)
    
    if not new or not previous then
        return
    end
    
    local result = {
		models = {},
		terrainAlignmentLists = {
			{
				type = "EQUAL",
				faces = {}
			}
		},
		groundFaces = {},
	}
    	
	local shorterResult = #new.powerline.configurationA
	if(shorterResult > #previous.powerline.configurationB) then
		shorterResult = #previous.powerline.configurationB
	end
		
	for k = 1, shorterResult do
		powerlines.buildCable(
			previous.transf, 
			new.transf, 
			previous.offset,
			new.offset,			
			previous.powerline.configurationB[k], 
			new.powerline.configurationA[k], 
			"asset/snowball/powerline/snowball_powerline_cable.mdl", 
			new.tension, 
			result
		)
	end
	
	powerlines.buildGround(new.position, result)
    
	local id = nil
	
	if #result.models > 0 then
	
	
		-- local proposal = api.type.SimpleProposal.new()
		
		-- local construction = api.type.SimpleProposal.ConstructionEntity.new()
		-- construction.fileName = "asset/snowball_powerline_off.con"
		-- construction.params.result = result

		-- proposal.constructionsToAdd[1] = construction
		
		-- local context = api.type.Context.new()
		-- context.player = api.engine.util.getPlayer()
		
		-- local callback = function(res, success)
			-- print(res)
			-- print(success)
			-- id = res.entities[1]
		-- end
		
		-- local cmd = api.cmd.make.buildProposal(proposal, context, false)
		
		-- api.cmd.sendCommand(cmd, callback)
		
		-- while id == nil do
		-- end
		
		id = game.interface.buildConstruction(
			"asset/snowball_powerline_off.con",
			{result = result},
			{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1})
			
		game.interface.setPlayer(id, api.engine.util.getPlayer())
    
	end
	
    return id
end

return powerlines
