local soundsetutil = require "soundsetutil"

local clackNames = {
	"vehicle/clack/modern/part_1.wav",
	"vehicle/clack/modern/part_2.wav",
	"vehicle/clack/modern/part_3.wav",
	"vehicle/clack/modern/part_4.wav",
	"vehicle/clack/modern/part_5.wav",
	"vehicle/clack/modern/part_6.wav",
	"vehicle/clack/modern/part_7.wav",
	"vehicle/clack/modern/part_8.wav",
	"vehicle/clack/modern/part_9.wav",
	"vehicle/clack/modern/part_10.wav"
}

function data()

local data = soundsetutil.makeSoundSet()

soundsetutil.addTrackParam01(data, "vehicle/train/600mm/omz_idle.wav", 7.0,
	{ 
		{ 0.0,  0.5 },
		{ 0.01, 0.6 },
		{ 0.5,  0.6 },
		{ 0.75, 0.0 }, }, 
	{ 
		{ 0.0,  0.6 },
		{ 0.01, 0.65 },
		{ 0.5,  0.7 }, },
	"speed01")

soundsetutil.addTrackParam01(data, "vehicle/train/600mm/omz_speeding.wav", 10.0,
	{ 
		{ 0.0, 0.1 },
		{ 0.5, 0.5 },
		{ 1.0, 1.1 }, }, 
	{ 
		{ 0.0, 0.3 },
		{ 0.5, 0.4 },
		{ 1.0, 0.5 }, }, 
	"speed01")

--soundsetutil.addTrackParam01(data, "vehicle/train/600mm/omz_idle.wav", 10.0,
	--{ 
	--	{ 0.0, 0.0 }, 
	--	{ 0.3, 0.0 },
	--	{ 0.6, 0.5 },
	--	{ 1.0, 1.0 }, }, 
	--{ 
	--	{ 0.0, 0.8 } }, 
	--"speed01")		
			
soundsetutil.addTrackSqueal(data, "vehicle/train/wheels_ringing1.wav", 25.0)
soundsetutil.addTrackBrake(data, "vehicle/train_electric_modern/_brakes.wav", 25.0, .5)

soundsetutil.addEventClacks(data, clackNames, 15.0, 10.0)

return data

end
