local powerlines = require "snowball/powerline/main"

local config = {}

config.powerlines = {
    jag_trafohaeuser = {
		{
			model = "asset/misc/jag_trafohaus_1.mdl",
			width = 3,
			offset = {0.5,0.5,0.5}, -- Offsetintervalls for parameters X,Y,Z(only in first variant per group needed)
			configurationA = {
				--Eingehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{5.01631, 0.8, -0.26812, 0.2},
				{4.71657, 0.8, 0.26812, 0.2},
				{4.41682, 0.8, -0.26812, 0.2},
				{4.11708, 0.8, 0.26812, 0.2},
			},
			configurationB = {
				--Ausgehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{5.01631, -0.8, -0.26812, 0.2},
				{4.71657, -0.8, 0.26812, 0.2},
				{4.41682, -0.8, -0.26812, 0.2},
				{4.11708, -0.8, 0.26812, 0.2},
			},
		},
		{
			model = "asset/misc/jag_trafohaus_1.mdl",
			width = 3,
			offset = {0.5,0.5,0.5}, -- Offsetintervalls for parameters X,Y,Z(only in first variant per group needed)
			configurationA = {
				--Eingehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{5.01631, -0.8, -0.26812, 0.2},
				{4.71657, -0.8, 0.26812, 0.2},
				{4.41682, -0.8, -0.26812, 0.2},
				{4.11708, -0.8, 0.26812, 0.2},
			},
			configurationB = {
				--Ausgehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{5.01631, 0.8, -0.26812, 0.2},
				{4.71657, 0.8, 0.26812, 0.2},
				{4.41682, 0.8, -0.26812, 0.2},
				{4.11708, 0.8, 0.26812, 0.2},
			},
		},
		{
			model = "asset/misc/jag_trafohaus_2.mdl",
			width = 3,
			offset = {0.5,0.5,0.5}, -- Offsetintervalls for parameters X,Y,Z(only in first variant per group needed)
			configurationA = {
				--Eingehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{6.6, 2.25, -0.45, 0.2},
				{6.6, 2.25, 0.15, 0.2},
				{6.2, 2.25, -0.15, 0.2},
				{6.2, 2.25, 0.45, 0.2},
			},
			configurationB = {
				--Ausgehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{6.6, -2.25, -0.15, 0.2},
				{6.6, -2.25, 0.45, 0.2},
				{6.2, -2.25, -0.45, 0.2},
				{6.2, -2.25, 0.15, 0.2},
			},
		},
		{
			model = "asset/misc/jag_trafohaus_2.mdl",
			width = 3,
			offset = {0.5,0.5,0.5}, -- Offsetintervalls for parameters X,Y,Z(only in first variant per group needed)
			configurationA = {
				--Eingehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{6.6, -2.25, -0.15, 0.2},
				{6.6, -2.25, 0.45, 0.2},
				{6.2, -2.25, -0.45, 0.2},
				{6.2, -2.25, 0.15, 0.2},
			},
			configurationB = {
				--Ausgehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{6.6, 2.25, -0.45, 0.2},
				{6.6, 2.25, 0.15, 0.2},
				{6.2, 2.25, -0.15, 0.2},
				{6.2, 2.25, 0.45, 0.2},
			},
		},
		{
			model = "asset/misc/jag_trafohaus_3.mdl",
			width = 3,
			offset = {0.5,0.5,0.5}, -- Offsetintervalls for parameters X,Y,Z(only in first variant per group needed)
			configurationA = {
				--Eingehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{5.86, 1.5, 0.0, 0.2},
				{5.86, 1.5, -0.6, 0.2},
				{5.86, 1.5, 0.6, 0.2},
			},
			configurationB = {
				--Ausgehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{5.86, -1.5, 0.0, 0.2},
				{5.86, -1.5, 0.2, 0.2},
				{5.86, -1.5, -0.2, 0.2},
			},
		},
		{
			model = "asset/misc/jag_trafohaus_3.mdl",
			width = 3,
			offset = {0.5,0.5,0.5}, -- Offsetintervalls for parameters X,Y,Z(only in first variant per group needed)
			configurationA = {
				--Eingehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{5.86, -1.5, 0.0, 0.2},
				{5.86, -1.5, 0.2, 0.2},
				{5.86, -1.5, -0.2, 0.2},
			},
			configurationB = {
				--Ausgehende Kabel
				--Eine Zeile pro Kabel, Format {Z,Y,X,Dicke des Kabels}
				{5.86, 1.5, 0.0, 0.2},
				{5.86, 1.5, -0.6, 0.2},
				{5.86, 1.5, 0.6, 0.2},
			},
		},
	},
}

function config.load()

    local existingPowerlines = {}

    for id,powerline in pairs(powerlines.powerlines) do               
        existingPowerlines[id] = powerline      
    end

    powerlines.powerlines = {}

    for id,powerline in pairs(config.powerlines) do               
        powerlines.powerlines[id] = powerline      
    end

    for id,powerline in pairs(existingPowerlines) do               
        powerlines.powerlines[id] = powerline      
    end

    

end 

return config

