function data()
	local t = { }

	t.name = _("Kanshi Nopole")
	t.desc = _("Track ohne Oberleitung")
	
	t.categories = { "Kanshi", } 

	t.yearFrom = 1849
	t.yearTo = 1849

	t.shapeWidth = 4.0
	t.shapeStep = 4.0
	t.shapeSleeperStep = 8.0 / 13.0

	t.ballastHeight = .3
	t.ballastCutOff = .1

	t.sleeperBase = t.ballastHeight
	t.sleeperLength = .24
	t.sleeperWidth = 2.6
	t.sleeperHeight = .08
	t.sleeperCutOff = .04

	t.railTrackWidth = 1.435
	t.railBase = t.sleeperBase + t.sleeperHeight
	t.railHeight = .15
	t.railWidth = .07
	t.railCutOff = .02
    
    t.embankmentSlopeLow = 0.75
    t.embankmentSlopeHigh = 2.5

	t.catenaryBase = 5.917 + t.railBase + t.railHeight
	t.catenaryHeight = 1.35
	t.catenaryPoleDistance = 24.0
	t.catenaryMaxPoleDistanceFactor = 2.0
	t.catenaryMinPoleDistanceFactor = 0.9

	t.trackDistance = 5.0

	t.speedLimit = 300.0 / 3.6
	t.speedCoeffs = { .9, 15.0, .63 }
	
	t.minCurveRadius = 44.0
	t.minCurveRadiusBuild = 60.0
	
	t.maxSlopeBuild = 0.075
	t.maxSlope = t.maxSlopeBuild * 1.6
	t.maxSlopeShape = t.maxSlope * 1.25
	
	t.slopeBuildSteps = 2

--	t.ballastMaterial = "station/train/UBF_np.mtl"
--	t.sleeperMaterial = "station/train/UBF_np.mtl"
	t.ballastMaterial = "track/ballast.mtl"
	t.sleeperMaterial = "track/sleeper_concrete.mtl"
	
	t.railMaterial = "station/train/UBF_np.mtl"
	t.catenaryMaterial = "station/train/UBF_np.mtl"
	t.tunnelWallMaterial = "station/train/UBF_np.mtl"
	t.tunnelHullMaterial = "station/train/UBF_np.mtl"


	t.catenaryPoleModel = "railroad/ubf_np.mdl"
	t.catenaryMultiPoleModel = "railroad/ubf_np.mdl"
	t.catenaryMultiGirderModel = "railroad/ubf_np.mdl"
	t.catenaryMultiInnerPoleModel = "railroad/ubf_np.mdl"

	t.bumperModel = "railroad/bumper.mdl"
	t.switchSignalModel = "railroad/switch_box.mdl"

--	t.fillGroundTex = "ballast_fill.lua"
	t.fillGroundTex = "ballast_fill_stone.lua"
	t.borderGroundTex = "ballast.lua"
	
	t.railModel ="railroad/tracks/single_rail.mdl"
	t.sleeperModel = "railroad/tracks/single_sleeper_high_speed.mdl"
--[[	t.sleeperModel = "railroad/tracks/single_sleeper_base.mdl"

	t.trackStraightModel = {
		"railroad/tracks/2m_base.mdl",
		"railroad/tracks/4m_base.mdl",
		"railroad/tracks/8m_base.mdl",
		"railroad/tracks/16m_base.mdl",
]]		
		
	t.sleeperModel = "railroad/tracks/single_sleeper_high_speed.mdl"
	t.trackStraightModel = {
		"railroad/tracks/2m_high_speed.mdl",
		"railroad/tracks/4m_high_speed.mdl",
		"railroad/tracks/8m_high_speed.mdl",
		"railroad/tracks/16m_high_speed.mdl",
	}

	t.cost = -1

	return t
end
