local creekBridge = require("creek_bridge_C")

function data()
	return {
		info = {
			minorVersion = 2,
			severityAdd = "NONE",
			severityRemove = "NONE",
			name = _("name"),                               
			description = _("moddesc"),

			authors = {                                       
				{   name = "melectro",  role = "CREATOR",	text = 'Constructor',	steamProfile = "70790454",	tfnetId = 24295,},
				{	name = "eis_os",  role = "CREATOR",	text = 'Script support',},
				},
			tags = { "street", "track", "script",  },
		},
		postRunFn = function (settings, params)
			local hasAutobahnMod = api.res.streetTypeRep.find('Autobahn.lua') >= 0
			local hasAbBauMod = api.res.streetTypeRep.find('Autobahn_construction.lua') >= 0
			local haspipeMod = api.res.trackTypeRep.find('pipe.lua') >= 0
			
			local has1000 = api.res.trackTypeRep.find('eis_os_1000mm.lua') >= 0
			local has760 = api.res.trackTypeRep.find('760_beton_betonmast.lua') >= 0

			local trackPath = "ui/tracks/"
			local TrackIcons = {
						( trackPath.."standard.tga"),	
						( trackPath.."high_speed.tga"),	
			}
			local TrackIconsC1 = TrackIcons
			local TrackIconsC2 = TrackIcons
			if has1000 then
				local Track1000Icons = {
							( trackPath.."eis_os_750mm.tga"),	
							( trackPath.."eis_os_1000mm.tga"),	
							( trackPath.."eis_os_1000mm_5_5m.tga"),	
				}			
				TrackIcons = creekBridge.mergeTable(TrackIcons, Track1000Icons)
			end
			if has760 then
--				local from = { 0, 1970, 2010}
--				local to   = { 0,    0,    0}
				TrackIcons = creekBridge.mergeTable(TrackIcons, {( trackPath.."760_holz_mariazellerbahn.tga"),})
				TrackIconsC1 = creekBridge.mergeTable(TrackIcons, {( trackPath.."760_beton_betonmast.tga"),})
				TrackIconsC2 = creekBridge.mergeTable(TrackIconsC1, {( trackPath.."760_y_betonmast.tga"),})
			end


			local AbnPath = "ui/streets/"
			local setparPath = "ui/streets/standard/"
			local setparIcons = { 
						( setparPath.."town_small_new.tga"),
						( setparPath.."town_medium_new.tga"),
						( setparPath.."town_large_new.tga"),
						( setparPath.."town_x_large_new.tga"),
						( setparPath.."town_small_one_way_new.tga"),
						( setparPath.."town_medium_one_way_new.tga"),
						( setparPath.."town_large_one_way_new.tga"),
						( setparPath.."country_small_new.tga"),
						( setparPath.."country_medium_new.tga"),
						( setparPath.."country_large_new.tga"),
						( setparPath.."country_x_large_new.tga"),
						( setparPath.."country_small_one_way_new.tga"),
						( setparPath.."country_medium_one_way_new.tga"),
						( setparPath.."country_large_one_way_new.tga"),
			}
			local setparstreetwidth =
			{
				5,7,11,15,3.6,7,9,2,3,10.5,14.5,0.7,3,8.5
			}

			local AutobahnIcons = {
							( AbnPath.."Autobahn_ausfahrt_large.tga"),
							( AbnPath.."Autobahn_ausfahrt_large_concrete.tga"),
							( AbnPath.."Autobahn.tga"),
							( AbnPath.."Autobahn_concrete.tga"),
							( AbnPath.."Autobahn_ausfahrt.tga"),
							( AbnPath.."Autobahn_ausfahrt_medium.tga"),
							( AbnPath.."country_medium_new_asphalt.tga"),
							( AbnPath.."Autobahn_ausfahrt_concrete.tga"),
							( AbnPath.."Autobahn_ausfahrt_medium_concrete.tga"),
							( AbnPath.."country_medium_new_concrete.tga"),
					}
			local Abnwidth =
			{
				8,8,12,12,1.5,3.5,3.5,1.5,3.5,3.5
			}	
			local AbBauIcons = {
							( AbnPath.."Autobahn_construction.tga"),
							( AbnPath.."Autobahn_construction_concrete.tga"),
					}
			local AbBauwidth =
			{
				12,12
			}	

			local climatePath = "ui/ground/"
			local climateIcons = {
							( climatePath.."dry.tga"),
							( climatePath.."water.tga"),
					}
			local climateTrackIcons = {
							( climatePath.."trackdry.tga"),
							( climatePath.."trackwater.tga"),
					}

			local street_fileC = "creek_bridge_streetC" 
			local track_fileC = "creek_bridge_trackC" 
			local track_fileC1 = "creek_bridge_trackC1"
			local track_fileC2 = "creek_bridge_trackC2"

----------------------
--  era C track bridge
----------------------
			local trackCon, trackTemp, trackDyn = creekBridge.createConstructionRail(track_fileC, _("desc"),  _("menudesc"), 1930, 1970 )
			local trackCon760, trackTemp760, trackDyn760 = creekBridge.createConstructionRail(track_fileC, _("desc"),  _("menudesc"), 1970, 2010 )
			local trackCon760y, trackTemp760y, trackDyn760y = creekBridge.createConstructionRail(track_fileC, _("desc"),  _("menudesc"), 2010, 0 )

			local ModParamsC = {
				paramPathC = setparPath,
				paramIconsC = setparIcons,
				streetwidthC = setparstreetwidth,
				Abn_PathC = AbnPath,
				HasPipeC = haspipeMod,
				TrackIconsC = TrackIcons,
			}
			local ModParamsC1 = {
				paramPathC = setparPath,
				paramIconsC = setparIcons,
				streetwidthC = setparstreetwidth,
				Abn_PathC = AbnPath,
				HasPipeC = haspipeMod,
				TrackIconsC = TrackIconsC1,
			}
			local ModParamsC2 = {
				paramPathC = setparPath,
				paramIconsC = setparIcons,
				streetwidthC = setparstreetwidth,
				Abn_PathC = AbnPath,
				HasPipeC = haspipeMod,
				TrackIconsC = TrackIconsC2,
			}			
			-- TODO: What parameters should be shown in the ui?
			-- trackDyn = only when first build
			-- trackCon = when first build and in configuration mode (elements will be shown first)
			local NumbOfBridges = {
						_("1"),_("2"),_("3"),
					}
			creekBridge.ui.addNumberOfBridges(trackCon,NumbOfBridges)
			creekBridge.ui.addNumberOfTracks(trackCon)
			creekBridge.ui.addRailing(trackCon)
			if haspipeMod then
				creekBridge.ui.addNumberOfPipes(trackCon)
			end
			creekBridge.ui.addBridgeSpan(trackCon)
			creekBridge.ui.addSpanX2(trackCon)
			creekBridge.ui.addHeight(trackCon)
			creekBridge.ui.addSignHeight(trackCon)
			creekBridge.ui.addClimate(trackCon, climateTrackIcons)
			creekBridge.ui.addWaterHeight(trackCon)
			creekBridge.ui.addCatenary(trackCon)
			creekBridge.ui.addTrackType(trackCon,TrackIcons)

			creekBridge.setConDescScriptFileAndParams(trackCon, track_fileC, ModParamsC)
			creekBridge.addToRepository(track_fileC, trackCon, trackTemp, trackDyn)

------  760 track
			creekBridge.ui.addNumberOfBridges(trackCon760,NumbOfBridges)
			creekBridge.ui.addNumberOfTracks(trackCon760)
			creekBridge.ui.addRailing(trackCon760)
			if haspipeMod then
				creekBridge.ui.addNumberOfPipes(trackCon760)
			end
			creekBridge.ui.addBridgeSpan(trackCon760)
			creekBridge.ui.addSpanX2(trackCon760)
			creekBridge.ui.addHeight(trackCon760)
			creekBridge.ui.addSignHeight(trackCon760)
			creekBridge.ui.addClimate(trackCon760, climateTrackIcons)
			creekBridge.ui.addWaterHeight(trackCon760)
			creekBridge.ui.addCatenary(trackCon760)
			creekBridge.ui.addTrackType(trackCon760,TrackIconsC1)

			creekBridge.setConDescScriptFileAndParams(trackCon760, track_fileC1, ModParamsC1)
			creekBridge.addToRepository(track_fileC1, trackCon760, trackTemp760, trackDyn760)

------  760y track
			creekBridge.ui.addNumberOfBridges(trackCon760y,NumbOfBridges)
			creekBridge.ui.addNumberOfTracks(trackCon760y)
			creekBridge.ui.addRailing(trackCon760y)
			if haspipeMod then
				creekBridge.ui.addNumberOfPipes(trackCon760y)
			end
			creekBridge.ui.addBridgeSpan(trackCon760y)
			creekBridge.ui.addSpanX2(trackCon760y)
			creekBridge.ui.addHeight(trackCon760y)
			creekBridge.ui.addSignHeight(trackCon760y)
			creekBridge.ui.addClimate(trackCon760y, climateTrackIcons)
			creekBridge.ui.addWaterHeight(trackCon760y)
			creekBridge.ui.addCatenary(trackCon760y)
			creekBridge.ui.addTrackType(trackCon760y,TrackIconsC2)

			creekBridge.setConDescScriptFileAndParams(trackCon760y, track_fileC2, ModParamsC2)
			creekBridge.addToRepository(track_fileC2, trackCon760y, trackTemp760y, trackDyn760y)

-----------------------
--  era C street bridge
-----------------------

			local streetConC, streetTemplateC, streetDynC = creekBridge.createConstructionStreet(street_fileC, _("desc"),  _("menudesc"), 1930, 0 )
			NumbOfBridges = {
						_("1"),_("2"),_("3"),_("4"),_("5"),_("6"),_("7"),_("8"),_("9"),_("10"),_("11"),_("12"),
					}
			creekBridge.ui.addNumberOfBridges(streetConC,NumbOfBridges)
			if haspipeMod then
				creekBridge.ui.addNumberOfPipes(streetConC)
			end
			creekBridge.ui.addBridgeSpan(streetConC)
			creekBridge.ui.addSpanX2(streetConC)
			creekBridge.ui.addHeight(streetConC)
			creekBridge.ui.addSignHeight(streetConC)
			creekBridge.ui.addClimate(streetConC, climateIcons)
			creekBridge.ui.addWaterHeight(streetConC)

			-- Now add autobahn mod data...
			if hasAutobahnMod then
				ModParamsC.streetwidthC = creekBridge.mergeTable(ModParamsC.streetwidthC, Abnwidth)
				ModParamsC.paramIconsC = creekBridge.mergeTable(ModParamsC.paramIconsC, AutobahnIcons)
			end

			if hasAbBauMod then
				ModParamsC.streetwidthC = creekBridge.mergeTable(ModParamsC.streetwidthC, AbBauwidth)
				ModParamsC.paramIconsC = creekBridge.mergeTable(ModParamsC.paramIconsC, AbBauIcons)
			end

			creekBridge.ui.addStreetTypeIcons(streetConC, ModParamsC.paramIconsC)
			creekBridge.setConDescScriptFileAndParams(streetConC, street_fileC, ModParamsC)
			creekBridge.addToRepository(street_fileC, streetConC, streetTemplateC, streetDynC)

		end
 
}
end








			