--local creekBridge = require "creek_bridge_C"
local creekBridgeStreet = {}

function creekBridgeStreet.updateFn(params, paramsFromModLuaC)
	local sign = params.signHeightC
	local bridgeNum = params.bridgeNumC
	local Pstreettype = params.streettypeC
	local clima = params.climateC
	local pHeight = params.heightC
	local HasPipe = paramsFromModLuaC.HasPipeC
	local Pipe = params.pipeC
	local bridgeSpan = params.spanC
	local streettype = string.gsub(string.gsub(paramsFromModLuaC.paramIconsC[(Pstreettype or 0)+1],"ui/streets/",""),".tga",".lua") 
	local streetwidth = paramsFromModLuaC.streetwidthC
	local WaterHeight = params.WaterHeightC
	local XX = 1 + params.spanX2C


		local result = { }
		result.groundFaces = { }
		result.models = { 	}
		local terrainFaces = { }
		local terrainFaces1 = { }
		local groundFace = { }
		local pipeedges = {}
		local pipeNodes = {}
		local streetedges = {}
		local bridgeedges = {}
		local streetNodes = {}
		local pipeNum = 0
		if HasPipe then
			pipeNum = Pipe 
		end
	
		if sign == 0 then sign = -1 end
		local height =  (sign * pHeight-4)/2 +1.9
		local pipeheight =  height - 2.9
		local waterheight =  height - WaterHeight/2 -2.5

		local cbw = bridgeSpan
		if cbw <  pipeNum then cbw = pipeNum end
		local X1 =  cbw*0.65
		local X = 1.8 /2
		local x2 = 0
		local j = -1
		local jIncrement = 1

		local Y =  streetwidth[Pstreettype+1] 
		local Y1 =  (Y-1)/5 *2+1

		
		
		if pipeNum == 1 then
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y1*1.25, 0, 0, 0, 0, 1, 0, 0, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",    transf = { -1, 0, 0, 0, 0, Y1+0.2, 0, 0, 0, 0, 1, 0, 0, 0, pipeheight, 1 } }
			pipeedges = {
					{ { 0.0,-Y-2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { 0.0,-Y-1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { 0.0, Y+1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { 0.0, Y+2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
			}
			pipeNodes =  { 0,3 }
		end
			
		if pipeNum == 2 then
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y1*1.25, 0, 0, 0, 0, 1, 0, X, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y1*1.25, 0, 0, 0, 0, 1, 0, -X, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y1+0.2, 0, 0, 0, 0, 1, 0, -X, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y1+0.2, 0, 0, 0, 0, 1, 0, X, 0, pipeheight, 1 } }
			pipeedges = {
					{ {-X,-Y-2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {-X,-Y-1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {-X, Y+1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {-X, Y+2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X,-Y-2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X,-Y-1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X, Y+1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X, Y+2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
			}
			pipeNodes =  { 0,3,4,7 }
		end
		if pipeNum == 3 then
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y1*1.25, 0, 0, 0, 0, 1, 0, 0, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y1*1.25, 0, 0, 0, 0, 1, 0, -X*2, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y1*1.25, 0, 0, 0, 0, 1, 0, X*2, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y1+0.2, 0, 0, 0, 0, 1, 0,0, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y1+0.2, 0, 0, 0, 0, 1, 0, -X*2, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y1+0.2, 0, 0, 0, 0, 1, 0, X*2, 0, pipeheight, 1 } }
			pipeedges = {
					{ {   0,-Y-2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {   0,-Y-1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {   0, Y+1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {   0, Y+2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {-X*2,-Y-2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {-X*2,-Y-1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {-X*2, Y+1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {-X*2, Y+2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*2,-Y-2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*2,-Y-1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*2, Y+1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*2, Y+2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
			}
			pipeNodes =  { 0,3,4,7,8,11, }
		end
		if pipeNum == 4 then
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y1*1.25, 0, 0, 0, 0, 1, 0, -X, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y1*1.25, 0, 0, 0, 0, 1, 0, X, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y1*1.25, 0, 0, 0, 0, 1, 0, -X*3, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y1*1.25, 0, 0, 0, 0, 1, 0, X*3, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y1+0.2, 0, 0, 0, 0, 1, 0, -X, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y1+0.2, 0, 0, 0, 0, 1, 0, X, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y1+0.2, 0, 0, 0, 0, 1, 0, -X*3, 0, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y1+0.2, 0, 0, 0, 0, 1, 0, X*3, 0, pipeheight, 1 } }
			pipeedges = {
					{ { -X, -Y-2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X, -Y-1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X,  Y+1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X,  Y+2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {  X, -Y-2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {  X, -Y-1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {  X,  Y+1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {  X,  Y+2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {-X*3,-Y-2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {-X*3,-Y-1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {-X*3, Y+1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {-X*3, Y+2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*3,-Y-2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*3,-Y-1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*3, Y+1.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*3, Y+2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
			}
			pipeNodes =  { 0,3,4,7,8,11,12,15 }
		end

			result.models[#result.models+1] = { id = "asset/railing_new_start_for_bridge_C.mdl",  transf = { -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, -Y+0.8, height-0.2, 1 } }
			result.models[#result.models+1] = { id = "asset/railing_new_start_mirrored_for_bridge_C.mdl",  transf = { 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0.0, Y-0.8, height-0.2, 1 } }

		for jLoop = 0,bridgeNum do
			j = j + jIncrement
			X = j*12

			if (pipeNum == 0 or j >= 1) and XX == 2 then 
				x2 = (j+1)*12
				jIncrement = 2
				result.models[#result.models+1] = { id = "bridge/creek_bridge_base_railing_eraC.mdl",  transf = { 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, x2, Y-0.8, height-0.2, 1 } }
				result.models[#result.models+1] = { id = "bridge/creek_bridge_base_railing_eraC.mdl",  transf = { -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, x2, -Y+0.8, height-0.2, 1 } }
				result.models[#result.models+1] = { id = "asset/railing_new.mdl",  transf = { 1.55, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, x2-6.0, -Y-1.52, height+0.7, 1 } }
				result.models[#result.models+1] = { id = "asset/railing_new.mdl",  transf = { -1.55, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, x2-6.0, Y+1.52, height+0.7, 1 } }
				result.models[#result.models+1] = { id = "bridge/creek_bridge_roof_eraC.mdl",  transf = { 1, 0, 0, 0, 0, Y1, 0, 0, 0, 0, 1, 0, x2, 0, height, 1 } }
			else
				x2 = X
			end
			result.models[#result.models+1] = { id = "bridge/creek_bridge_base_railing_eraC.mdl",  transf = { 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, X, Y-0.8, height-0.2, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_base_railing_eraC.mdl",  transf = { -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, X, -Y+0.8, height-0.2, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_vault_eraC.mdl",  transf = { 1, 0, 0, 0, 0, Y1*1.3, 0, 0, 0, 0, 1, 0, x2+X1, 0, height, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_vault_eraC.mdl",  transf = { -1, 0, 0, 0, 0, -Y1*1.3, 0, 0, 0, 0, 1, 0, X-X1, 0, height, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_roof_eraC.mdl",  transf = { 1, 0, 0, 0, 0, Y1, 0, 0, 0, 0, 1, 0, X, 0, height, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_vault_fix_eraCL.mdl",  transf = { 1, 0, 0, 0, 0, Y1*1.3, 0, 0, 0, 0, 1, 0, x2, 0, height, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_vault_fix_eraCL.mdl",  transf = { -1, 0, 0, 0, 0, -Y1*1.3, 0, 0, 0, 0, 1, 0, X, 0, height, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_vault_fix_eraCR.mdl",  transf = { 1, 0, 0, 0, 0, Y1*1.3, 0, 0, 0, 0, 1, 0, x2, 0, height, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_vault_fix_eraCR.mdl",  transf = { -1, 0, 0, 0, 0, -Y1*1.3, 0, 0, 0, 0, 1, 0, X, 0, height, 1 } }
			if j > 0 then
				result.models[#result.models+1] = { id = "asset/railing_new.mdl",  transf = { 1.55, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, X-6.0, -Y-1.52, height+0.7, 1 } }
				result.models[#result.models+1] = { id = "asset/railing_new.mdl",  transf = { -1.55, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, X-6.0, Y+1.52, height+0.7, 1 } }
			end
			X1 =  bridgeSpan *0.65
		end

			result.models[#result.models+1] = { id = "asset/railing_new_start_for_bridge_C.mdl",  transf = { 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, x2, Y-0.8, height-0.2, 1 } }
			result.models[#result.models+1] = { id = "asset/railing_new_start_mirrored_for_bridge_C.mdl",  transf = { -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, x2, -Y+0.8, height-0.2, 1 } }
		
		local waterwidth = cbw*0.6 + 1.5
		local waterModule1 = -waterwidth

		groundFace = { {-8, Y+3}, { x2+8, Y+3}, {x2+8, -Y-3}, {-8, -Y-3} }
		result.groundFaces[#result.groundFaces + 1] = { face = groundFace, modes = { { type = "FILL", key = "oilterm_groundtex_grass_gravel.lua" } } }

		if pipeNum > 0 then
		--  pipe
			waterModule1 = 9.5
			if bridgeNum > 0 then terrainFaces1[#terrainFaces1 + 1] = {{x2+5.0, -4-Y,waterheight},{ 5.5, -4-Y,waterheight},{ 5.5, 4+Y,waterheight},{x2+5.0,4+Y,waterheight},}		end
			terrainFaces[#terrainFaces + 1] = {{4.5, -4-Y,pipeheight},{ -5, -4-Y,pipeheight},{ -5, 4+Y,pipeheight},{4.5,4+Y,pipeheight},}		
		else
		-- No pipe			
			terrainFaces1[#terrainFaces1 + 1] = {{ x2+5.0, -4-Y,waterheight},{ -5, -4-Y,waterheight},{ -5, 4+Y,waterheight},{x2+5.0,4+Y,waterheight},}		
		end	

		if clima == 1 and (pipeNum == 0 or bridgeNum > 0) then

			groundFace = { {waterModule1, Y+4}, { x2+waterwidth-1, Y+4}, {x2+waterwidth, -Y-4}, {waterModule1, -Y-4} }
			result.groundFaces[#result.groundFaces + 1] = { face = groundFace, modes = { { type = "FILL", key = "oilterm_water_ground.lua" } } }
		else
			-- No water
--				terrainFaces1[#terrainFaces1 + 1] = {{ X+4.5, -Y-4,pipeheight-0.05},{ -4.5, -Y-4,pipeheight-0.05},{ -4.5, 4+Y,pipeheight-0.05},{X+4.5,4+Y,pipeheight-0.05},}		
		end		
		
		
			streetedges = {
					{ { -6, 0, height }, { 1, 0.0, 0.0 } },
					{ { -5, 0, height }, { 1, 0.0, 0.0 } },
					{ {x2+5, 0, height }, { 1, 0.0, 0.0 } },
					{ {x2+6, 0, height }, { 1, 0.0, 0.0 } },
			}
			streetNodes =  { 0,3 }

			bridgeedges = {
					{ { -5, 0, height }, 	{ x2+10, 0.0, 0.0 } },
					{ {x2+5, 0, height }, 	{ x2+10, 0.0, 0.0 } },
			}

		result.terrainAlignmentLists = {
				{
					type = "EQUAL",
					faces = terrainFaces,
					slopeLow =  8, 
					slopeHigh = 12
				},
				{
			--		type = "EQUAL",
					type = "LESS",
					faces = terrainFaces1,
					slopeLow = 8,  
					slopeHigh = 12
				}
			}		
		
		result.edgeLists = {
			{
				type = "TRACK",
				params = { type = "pipe.lua", catenary =  false }, 
				edges = pipeedges,
				snapNodes = pipeNodes,
			},
			{
				type = "STREET", 
				alignTerrain = true,
				params = { type = streettype},
				edges = streetedges,
				snapNodes = streetNodes,
--				edgeType = "BRIDGE",
--				edgeTypeName = "creekbridgeA_inv.lua",
			},
			{
				type = "STREET", 
				alignTerrain = false,
				params = { type = streettype},
				edges = bridgeedges,
				snapNodes = {},
				edgeType = "BRIDGE",
				edgeTypeName = "creekbridgeC_inv.lua",
			},
		}


		
		result.cost = 50000 * Y

		return result
end

return creekBridgeStreet