local creekBridge = require "creek_bridge_C"
local creekBridgeTrack = {}


function creekBridgeTrack.updateFn(params, paramsFromModLuaC)
	local sign = params.signHeightC
	local bridgeNum = params.bridgeNumC
	local trackNum = params.trackNumC
	local pole = params.PoleC
	local catenary = params.catenaryC
	local trackType = params.tracktypeC
	local clima = params.climateC
	local pHeight = params.heightC
	local HasPipe = paramsFromModLuaC.HasPipeC
	local Pipe = params.pipeC
	local bridgeSpan = params.spanC
	local WaterHeight = params.WaterHeightC
	local XX = 1 + params.spanX2C
	local railing = params.RailingC


	local result = { }
	result.groundFaces = { }
	result.models = { 	}
	local edgeList = { 	}
	local terrainFaces = { }
	local terrainFaces1 = { }
	local groundFace = { }
	local pipeedges = {}
	local pipeNodes = {}
	local trackedges = {}
	local trackNodes = {}
	local trackedges1 = {}
	local trackNodes1 = {}
	local pipeNum = 0

	if HasPipe then pipeNum = Pipe end
	
	local tracktype = string.gsub(string.gsub(paramsFromModLuaC.TrackIconsC[(trackType or 0)+1],"ui/tracks/",""),".tga",".lua") 

	if sign == 0 then sign = -1 end
	local height =  (sign * pHeight-4)/2 + 3
	local pipeheight =  height - 2.9
	local waterheight =  height - WaterHeight/2 -2.5
	
	local cbw = bridgeSpan
	if cbw <  pipeNum then cbw = pipeNum end
	local X1 =  cbw*0.65
	local x2 = 0
	local j = -1
	local jIncrement = 1
	local Y = trackNum +1
	local Y1 = trackNum *5

	local X = 1.8 /2

		if pipeNum == 1 then
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y*1.25-0.25, 0, 0, 0, 0, 1, 0, 0, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y, 0, 0, 0, 0, 1, 0,0, Y1/2, pipeheight, 1 } }
			pipeedges = {
					{ { 0.0, -2.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {  0.0, -2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { 0.0, 2.0+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ {  0.0, 2.5+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
			}
			pipeNodes =  { 0,3 }
		end
		if pipeNum == 2 then
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y*1.25-0.25, 0, 0, 0, 0, 1, 0, X, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y*1.25-0.25, 0, 0, 0, 0, 1, 0, -X, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y, 0, 0, 0, 0, 1, 0, -X, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y, 0, 0, 0, 0, 1, 0, X, Y1/2, pipeheight, 1 } }
			pipeedges = {
					{ { -X, -2.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X, -2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X, 2.0+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X, 2.5+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X, -2.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X, -2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X, 2.0+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X, 2.5+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
			}
			pipeNodes =  { 0,3,4,7 }
		end
		if pipeNum == 3 then
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y*1.25-0.25, 0, 0, 0, 0, 1, 0, 0, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y*1.25-0.25, 0, 0, 0, 0, 1, 0, -X*2, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y*1.25-0.25, 0, 0, 0, 0, 1, 0, X*2, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y, 0, 0, 0, 0, 1, 0,0, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y, 0, 0, 0, 0, 1, 0, -X*2, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y, 0, 0, 0, 0, 1, 0, X*2, Y1/2, pipeheight, 1 } }
			pipeedges = {
					{ { 0, -2.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { 0, -2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { 0, 2.0+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { 0, 2.5+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X*2, -2.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X*2, -2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X*2, 2.0+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X*2, 2.5+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*2, -2.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*2, -2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*2, 2.0+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*2, 2.5+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
			}
			pipeNodes =  { 0,3,4,7,8,11, }
			end
		if pipeNum == 4 then
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y*1.25-0.25, 0, 0, 0, 0, 1, 0, -X, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y*1.25-0.25, 0, 0, 0, 0, 1, 0, X, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y*1.25-0.25, 0, 0, 0, 0, 1, 0, -X*3, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/pipeline_under_eraC.mdl",  transf = { -1, 0, 0, 0, 0, Y*1.25-0.25, 0, 0, 0, 0, 1, 0, X*3, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y, 0, 0, 0, 0, 1, 0, -X, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y, 0, 0, 0, 0, 1, 0, X, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y, 0, 0, 0, 0, 1, 0, -X*3, Y1/2, pipeheight, 1 } }
			result.models[#result.models+1] = { id = "bridge/CB_pipeline_inner_5m.mdl",  transf = { -1, 0, 0, 0, 0, Y, 0, 0, 0, 0, 1, 0, X*3, Y1/2, pipeheight, 1 } }
			pipeedges = {
					{ { -X, -2.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X, -2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X, 2.0+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X, 2.5+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X, -2.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X, -2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X, 2.0+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X, 2.5+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X*3, -2.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X*3, -2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X*3, 2.0+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { -X*3, 2.5+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*3, -2.5, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*3, -2.0, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*3, 2.0+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
					{ { X*3, 2.5+Y1, pipeheight }, 	{ 0.0, 0.5, 0.0 } },
			}
			pipeNodes =  { 0,3,4,7,8,11,12,15 }

		end

		for jLoop = 0,bridgeNum do
			j = j + jIncrement
			X = j*12		
			if railing == 1 then
				result.models[#result.models+1] = { id = "bridge/creek_bridge_railing_eraC.mdl",  transf = { 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, X, Y1, height, 1 } }
				result.models[#result.models+1] = { id = "bridge/creek_bridge_railing_eraC.mdl",  transf = { -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, X, 0, height, 1 } }
			end

			if (pipeNum == 0 or j >= 1) and XX == 2 then 
				x2 = (j+1)*12
				jIncrement = 2
				result.models[#result.models+1] = { id = "bridge/creek_bridge_base_railing_eraC.mdl",  transf = { 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, x2, Y1, height, 1 } }
				result.models[#result.models+1] = { id = "bridge/creek_bridge_base_railing_eraC.mdl",  transf = { -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, x2, 0, height, 1 } }
				if railing == 1 then
					result.models[#result.models+1] = { id = "bridge/creek_bridge_railing_eraC.mdl",  transf = { 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, x2, Y1, height, 1 } }
					result.models[#result.models+1] = { id = "bridge/creek_bridge_railing_eraC.mdl",  transf = { -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, x2, 0, height, 1 } }
				end
				for i = 0,trackNum do
					result.models[#result.models+1] = { id = "bridge/creek_bridge_roof_eraC.mdl",  transf = { 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, x2, i*5, height, 1 } }
				end
			else
				x2 = X
			end
			result.models[#result.models+1] = { id = "bridge/creek_bridge_base_railing_eraC.mdl",  transf = { 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, X, Y1, height, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_base_railing_eraC.mdl",  transf = { -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, X, 0, height, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_vault_eraC.mdl",  transf = { 1, 0, 0, 0, 0, Y*1.3, 0, 0, 0, 0, 1, 0, x2+X1, Y1/2, height, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_vault_eraC.mdl",  transf = { -1, 0, 0, 0, 0, -Y*1.3, 0, 0, 0, 0, 1, 0, X-X1, Y1/2, height, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_vault_fix_eraCL.mdl",  transf = { 1, 0, 0, 0, 0, Y*1.3, 0, 0, 0, 0, 1, 0, x2, Y1/2, height, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_vault_fix_eraCL.mdl",  transf = { -1, 0, 0, 0, 0, -Y*1.3, 0, 0, 0, 0, 1, 0, X, Y1/2, height, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_vault_fix_eraCR.mdl",  transf = { 1, 0, 0, 0, 0, Y*1.3, 0, 0, 0, 0, 1, 0, x2, Y1/2, height, 1 } }
			result.models[#result.models+1] = { id = "bridge/creek_bridge_vault_fix_eraCR.mdl",  transf = { -1, 0, 0, 0, 0, -Y*1.3, 0, 0, 0, 0, 1, 0, X, Y1/2, height, 1 } }

			for i = 0,trackNum do
				result.models[#result.models+1] = { id = "bridge/creek_bridge_roof_eraC.mdl",  transf = { 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, X, i*5, height, 1 } }
			end
			X1 =  bridgeSpan *0.65
		end	
		

		local SnapXnode = {	0,6,18 } -- *1
		if XX == 2 then 
			if pipeNum == 0 then 
				SnapXnode = { 6,18,18 }
			else
				SnapXnode = { 0,6,30 }
			end
		end
		
		for i = 0,trackNum do
			local T23edges = {
						{ { -6.0 , i*5, height }, {SnapXnode[bridgeNum+1]+6, 0.0, 0.0 } },
						{ { SnapXnode[bridgeNum+1], i*5, height }, {SnapXnode[bridgeNum+1]+6, 0.0, 0.0 } },
						{ { SnapXnode[bridgeNum+1], i*5, height }, { x2-SnapXnode[bridgeNum+1]+6, 0.0, 0.0 } },
						{ { x2+6.0 , i*5, height }, { x2-SnapXnode[bridgeNum+1]+6, 0.0, 0.0 } },
					}
			local T23snapNodes = { 0+i*4,3+i*4 }

			local T1edges = {
						{ {   -6.0, i*5, height }, {12, 0.0, 0.0 } },
						{ { x2+6.0, i*5, height }, { x2+12, 0.0, 0.0 } },
					}
			local T1snapNodes = { 0+i*4,1+i*4 }	

			if bridgeNum == 0 then
				trackedges1 = T23edges
				trackNodes1 = T23snapNodes
			else
				trackedges1 = T23edges
				trackNodes1 = T23snapNodes
			end	


			trackNodes1 =  { 0+i*4,3+i*4 }
			trackedges = creekBridge.mergeTable(trackedges,trackedges1)
			trackNodes = creekBridge.mergeTable(trackNodes,trackNodes1)
			
		end
		result.edgeLists = {
			{
				type = "TRACK",
				params = { type = "pipe.lua", catenary =  false }, 
				edges = pipeedges,
				snapNodes = pipeNodes,
			},
			{
				type = "TRACK",
				params = { type = tracktype, catenary =  (catenary == 1) }, 
				edges = trackedges,
				snapNodes = trackNodes,
				edgeType = "BRIDGE",
				edgeTypeName = "creekbridgeC_inv.lua",
			},
		}

		groundFace = { {-6.5, 3+Y1}, { x2+6.5, 3+Y1}, {x2+6.5, -3}, {-6.5, -3} }
		result.groundFaces[#result.groundFaces + 1] = { face = groundFace, modes = { { type = "FILL", key = "oilterm_groundtex_grass_gravel.lua" } } }

		local waterwidth = cbw*0.6 + 0.5
		local waterModule1 = -waterwidth

		if pipeNum > 0 then
		--  pipe
			waterModule1 = 9.5
			if bridgeNum > 0 then terrainFaces1[#terrainFaces1 + 1] = {{x2+5.0, -2.5,waterheight},{ 5.5, -2.5,waterheight},{ 5.5, 2.5+Y1,waterheight},{x2+5.0,2.5+Y1,waterheight},}		end
			terrainFaces[#terrainFaces + 1] = {{4.5, -4,pipeheight},{ -5, -4,pipeheight},{ -5, 4+Y1,pipeheight},{4.5,4+Y1,pipeheight},}		
		else
		-- No pipe			
			terrainFaces1[#terrainFaces1 + 1] = {{ x2+5.0, -3,waterheight},{ -5, -3,waterheight},{ -5, 3+Y1,waterheight},{x2+5.0,3+Y1,waterheight},}		
		end	

		if clima == 1 and (pipeNum == 0 or bridgeNum > 0) then
		-- Water
			groundFace = { {waterModule1, 3+Y1}, { x2+waterwidth, 3+Y1}, {x2+waterwidth, -3}, {waterModule1, -3} }
--			groundFace = { {waterModule1+4, 3+Y1}, { X+waterwidth, 3+Y1}, {X+waterwidth, -3}, {waterModule1+4, -3} }
			result.groundFaces[#result.groundFaces + 1] = { face = groundFace, modes = { { type = "FILL", key = "oilterm_water_ground.lua" } } }
		else
		--dry 
		end
--		terrainFaces[#terrainFaces + 1] = { { X+6.5, -2.8, height},{X+5, -2.8, height},{X+5, 2.8+Y1, height},{X+6.5,2.8+Y1, height},}		
--		terrainFaces[#terrainFaces + 1] = { {  -6.5, -2.8, height},{ -5, -2.8, height},{ -5, 2.8+Y1, height},{ -6.5,2.8+Y1, height},}		
		result.terrainAlignmentLists = {
				{
					type = "EQUAL",
					faces = terrainFaces,
					slopeLow =  8, 
					slopeHigh = 12
				},
				{
					type = "LESS",
					faces = terrainFaces1,
					slopeLow = 8,  
					slopeHigh = 12
				}
		}			
		
		result.cost = 120000*Y*(bridgeNum+1) + 70000

		return result
end

return creekBridgeTrack