local fences = require "snowball/fences/main"
local mat3 = require "snowball/common/mat3_1"
local vec3 = require "snowball/common/vec3_1"

local state = {}

local function getFence(params)
    
    if not params.proposal.toAdd or #params.proposal.toAdd == 0 then
        return nil
    end
	
    local added = params.proposal.toAdd[1]  

    local fence = string.match(added.fileName, "^.+/(.+)%.con$")
    if not fences.fences[fence] then
        return
    end
	
	
	local fenceConfig = fences.fences[fence]
	
    local position = {added.transf[13], added.transf[14], added.transf[15]}
	local offsetZ = 0
	
	
	if fenceConfig[1] == nil and added.params.snowball_fences_offset ~= nil then
		local offset = fences.getOffsetFromParam(added.params.snowball_fences_offset)
		if offset ~= 0 then
			local transform = {
				{added.transf[1], added.transf[5], added.transf[9]},
				{added.transf[2], added.transf[6], added.transf[10]},
				{added.transf[3], added.transf[7], added.transf[11]}
			}
			
			position = vec3.add(position, mat3.transform(transform, {0, offset, 0}))
		end
	end
	if fenceConfig[1] ~= nil and (added.params.snowball_fences_offset_x ~= nil or added.params.snowball_fences_offset_y ~= nil or added.params.snowball_fences_offset_z ~= nil) then
		local offsets = fences.getOffsetFromParamAdvanced(added.params,fenceConfig[1].offset)
		
		local transform = {
			{added.transf[1], added.transf[5], added.transf[9]},
			{added.transf[2], added.transf[6], added.transf[10]},
			{added.transf[3], added.transf[7], added.transf[11]}
		}
		position = vec3.add(position, mat3.transform(transform, offsets))
		offsetZ = offsets[3]
	end
	
	
	
	local mode = added.params.snowball_fences_mode or fences.fences[fence][1].fixMode
	
	
	local invertedModel = false
	if fenceConfig[1] ~= nil then
		invertedModel = fences.fences[fence][added.params.snowball_fences_type + 1].invertedModel
	end
	
    local result = {
        fence = fence,
		type = added.params.snowball_fences_type or nil,
        mode = mode,
        face = added.params.snowball_fences_face,
        adjust = added.params.snowball_fences_adjust,
        stepped = added.params.snowball_fences_stepped,
        collision = added.params.snowball_fences_collision,
        position = position,
		offsetZ = offsetZ,
		invertedModel = invertedModel
    }
    if params.result and #params.result > 0 then
        result.id = params.result[1]
    end
    
	
    return result
end

local function removePreview()
    if state.previewId then
        game.interface.bulldoze(state.previewId)
        state.previewId = nil
    end
end

function data()
    return {                
        handleEvent = function(src, id, name, param)
            
            if id ~= "__fencesEvent__" or src ~= "snowball_fences_callback.lua" then
                return
            end
            
            removePreview()
            
            if name == "builder.apply" then
                                
                state.fence = param.fence
				state.type = param.type
                state.face = param.face
                state.collision = param.collision
                state.adjust = param.adjust
                state.stepped = param.stepped
                state.segmentType = param.segmentType
				state.offsetZ = param.offsetZ
				state.invertedModel = param.invertedModel
                
                if param.id then
                    game.interface.bulldoze(param.id)
                end
                
                if state.from then
                    
                    state.to = param.position
                    
					local fence = fences.fences[state.fence]
					if fence[1] ~= nil then
						fence = fences.fences[state.fence][state.type + 1]
					end
					
                    local id, tangent = fences.build(
                        state.previous ~= nil, 
                        state.previous, 
                        state.from, 
                        state.to, 
                        fence, 
                        state.face or 0, 
                        state.adjust or 0, 
                        state.stepped or 0, 
                        state.collision or 0, 
                        state.segmentType or 0,
						state.offsetZ or 0,
						state.invertedModel)
                    state.previous = tangent
                                        
                    state.from = state.to
                else
                    state.from = param.position
                end
            
            elseif name == "builder.proposalCreate" and state.from then
                
                state.fence = param.fence
				state.type = param.type
                state.face = param.face
                state.collision = param.collision
                state.adjust = param.adjust
                state.stepped = param.stepped
                state.segmentType = param.segmentType
				state.offsetZ = param.offsetZ
				state.invertedModel = param.invertedModel
                
				
				local fence = fences.fences[state.fence]
				if fence[1] ~= nil then
					fence = fences.fences[state.fence][state.type + 1]
				end
				
                state.to = param.position
                local id, tangent = fences.build(
                    state.previous ~= nil, 
                    state.previous, 
                    state.from, 
                    state.to, 
                    fence, 
                    state.face or 0, 
                    state.adjust or 0, 
                    state.stepped or 0, 
                    fences.collisionOff, 
                    state.segmentType or 0,
					state.offsetZ or 0,
					state.invertedModel)

                state.previewId = id
            elseif name == "finish" then
                
                state.previous = nil
                state.from = nil
                state.to = nil
            end
        end,        
        guiHandleEvent = function(id, name, param)
                        
            --The user navigated away from the fences-tab.
            if name == "visibilityChange" and param == false then

                local fence = string.match(id, "^.+/(.+)%.con$")
                
                if not fence or not fences.fences[fence] then
                    return
                end
                
                game.interface.sendScriptEvent("__fencesEvent__", "finish", {})
            --The user either built a fence segment or is previewing it
            elseif name == "builder.apply" or name == "builder.proposalCreate" then
                
                local params = getFence(param)
                if not params then
                    return
                end
				
                if params.mode == fences.modeFinish then
                    game.interface.sendScriptEvent("__fencesEvent__", "finish", {})
                else
                    params.segmentType = params.mode
                    game.interface.sendScriptEvent("__fencesEvent__", name, params)
                end
            end
        end
    }
end
