local fences = require "snowball/fences/main"

local config = {}

config.fences = {
    snowball_fence_wood = {
        {
			post = "snowball/fences/new/wood_post.mdl",
			middle = "snowball/fences/new/wood_middle.mdl",        
			length = 3.0,
			offset = {0.15,.5,0.15},
			invertedModel = true,
		},
		{ 
			post = nil,        
			middle = "snowball/fences/new/wire_wood.mdl",        
			length = 4.14998,
			invertedModel = true,
		},
		{
			post = "snowball/fences/new/cow_post.mdl",
			middle = "snowball/fences/new/cow_middle.mdl",        
			length = 2.11874,
			invertedModel = true,
		},
		{
			post = nil,        
			middle = "snowball/fences/new/stockade_middle.mdl",
			length = 3.3734,
			invertedModel = true,
		},
    },
	
    snowball_fence_brick = {        
        {
			post = "snowball/fences/new/brick_wall1_post_01.mdl",
			middle = "snowball/fences/new/brick_wall1_middle_01.mdl",        
			length = 3.68486,
			offset = {0.15,.5,0.15},
			invertedModel = true,
		}, 
        {
			post = "snowball/fences/new/brick_wall1_post_01.mdl",
			middle = "snowball/fences/new/brick_wall1_middle_02.mdl",
			length = 3.68486,
			invertedModel = true,
		},
        {
			post = "snowball/fences/new/brick_wall1_post_01.mdl",
			middle = "snowball/fences/new/brick_wall1_middle_03.mdl",
			length = 3.68486,
			invertedModel = true,
		},
        {
			post = "snowball/fences/new/brick_wall1_post_01.mdl",
			middle = "snowball/fences/new/brick_wall1_middle_04.mdl",
			length = 3.68486,
			invertedModel = true,
		},
        {
			post = "snowball/fences/new/brick_wall1_post_01.mdl",
			middle = "snowball/fences/new/brick_wall1_middle_05.mdl",
			length = 3.68486,
			invertedModel = true,
		},
        {  
			post = "snowball/fences/new/brick_wall1_post_01.mdl",
			middle = "snowball/fences/new/brick_wall1_middle_06.mdl",
			length = 3.68486,
			invertedModel = true,
		},
        {   
			post = "snowball/fences/new/brick_wall1_post_01.mdl",
			middle = "snowball/fences/new/brick_wall1_middle_08.mdl",
			length = 3.68486,
			invertedModel = true,
		},
    },
	
    snowball_fence_white = {        
        {
			post = "snowball/fences/new/brick_wall2_post_01.mdl",
			middle = "snowball/fences/new/brick_wall2_middle_01.mdl",
			length = 2.35,
			offset = {0.15,.5,0.15},
			invertedModel = true,
		},
		{
			post = "snowball/fences/new/brick_wall2_post_01.mdl",
			middle = "snowball/fences/new/brick_wall2_middle_02.mdl",
			length = 2.2,
			invertedModel = true,
		},
		{
			post = "snowball/fences/new/brick_wall2_post_01.mdl",
			middle = "snowball/fences/new/brick_wall2_middle_03.mdl",
			length = 2.0,
			invertedModel = true,
		}
    },
	
    snowball_fence_railing = {
		{
			post = nil,        
			middle = "snowball/fences/new/railing_new.mdl",
			length = 7.9485840797424,
			offset = {0.15,.5,0.15},
			invertedModel = true,
		}
	}, 
	
    snowball_fence_construction_site = {
		{
			post = "snowball/fences/new/bauzaun_fuss.mdl",        
			middle = "snowball/fences/new/bauzaun.mdl",
			length = 3.55,
			offset = {0.15,.5,0.15},
			invertedModel = true,
		}
	}, 
   
    snowball_fence_metals = {    
		{
			post = "snowball/fences/new/metal_post.mdl",
			middle = "snowball/fences/new/metal_middle.mdl",        
			length = 2.8,
			offset = {0.15,.5,0.15},
			invertedModel = true,
		},
		{
			post = nil,        
			middle = "snowball/fences/new/mesh_middle.mdl",
			length = 3.05,
			invertedModel = true,
		},
		{
			post = nil,        
			middle = "snowball/fences/new/rods_middle.mdl",
			length = 2.5,
			invertedModel = true,
		},
		{    
			post = nil,
			middle = "snowball/fences/new/brick_wall3_middle_01.mdl",
			length = 2.2,
			invertedModel = true,
		}
	},
	
    snowball_fence_hedges = {    
		{
			post = nil,        
			middle = "snowball/fences/new/hedge.mdl",        
			length = 1,
			offset = {0.15,.5,0.15},
			invertedModel = true,
		},
		{          
			post = nil,        
			middle = nil,  
			decoration = {"snowball/fences/new/azalea.mdl"},      
			length = 1,
			invertedModel = true,
		},
	},   
}

function config.load()

    local existingFences = {}

    for id,fence in pairs(fences.fences) do               
        existingFences[id] = fence      
    end

    fences.fences = {}

    for id,fence in pairs(config.fences) do               
        fences.fences[id] = fence      
    end

    for id,fence in pairs(existingFences) do               
        fences.fences[id] = fence      
    end

    

end 

return config

