function data()
	local t = { }

	t.name = _("600mm_stahl_08_name")
	t.desc = _("600mm_stahl_08_desc")
	t.categories = {"600mm"}
	t.order = 10610

	t.yearFrom = 0
	t.yearTo = 0

	t.shapeWidth = 2
	t.shapeStep = 1.5
	t.shapeSleeperStep = 16.0 / 8.0

	t.ballastHeight = 0
	t.ballastCutOff = .1

	t.sleeperBase = -0.03
	t.sleeperLength = 0
	t.sleeperWidth = 0
	t.sleeperHeight = 0
	t.sleeperCutOff = .1

	t.railTrackWidth = 0.5900
	t.railBase = t.sleeperBase + t.sleeperHeight -0.04
	t.railHeight = .11
	t.railWidth = .07
	t.railCutOff = .02
    
    t.embankmentSlopeLow = 0.75
    t.embankmentSlopeHigh = 2.5

	t.catenaryBase = -0.5 + t.railBase + t.railHeight
	t.catenaryHeight = 0
	t.catenaryPoleDistance = 100

	t.trackDistance = 5.0

	t.speedLimit = 30.0 / 3.6
	t.speedCoeffs = { .85, 30.0, .6 }		-- curve speed limit = a * (radius + b) ^ c

	t.minCurveRadiusBuild = 15.0         -- [m] minimal radius when dragging
	t.minCurveRadius = 10.0              -- [m] minimal radius when snapping (and parallel tracks)
	 
	t.maxSlopeBuild = 0.15
	t.maxSlope = t.maxSlopeBuild * 1.6
	t.maxSlopeShape = t.maxSlope * 1.25
	 
	t.slopeBuildSteps = 4                -- [1-4] steps for slope arrow buttons

	t.ballastMaterial = "track/600mm/procedural_ballast_none.mtl"
	t.sleeperMaterial = "track/600mm/procedural_sleeper_steel.mtl"
	t.railMaterial = "track/600mm/procedural_rail.mtl"
	t.catenaryMaterial = "track/procedural_ballast_none.mtl"
	t.tunnelWallMaterial = "track/tunnel_rail_ug.mtl"
	t.tunnelHullMaterial = "track/tunnel_hull.mtl"

	t.catenaryPoleModel = "hidden.mdl"
	t.catenaryMultiPoleModel = "hidden.mdl"
	t.catenaryMultiGirderModel = "hidden.mdl"
	t.catenaryMultiInnerPoleModel = "hidden.mdl"

	t.bumperModel = "railroad/bumper600.mdl"

	t.fillGroundTex = "none.lua"
	t.borderGroundTex = "none.lua"
	
	t.railModel ="railroad/tracks/single_rail_600mm_08.mdl"
	t.sleeperModel = "hidden.mdl"
	t.trackStraightModel = {
		"railroad/tracks/2m_stahl_600mm_08.mdl",
		"railroad/tracks/4m_stahl_600mm_08.mdl",
		"railroad/tracks/8m_stahl_600mm_08.mdl",
		"railroad/tracks/16m_stahl_600mm_08.mdl",
	}

	t.cost = 50.0

	return t
end
