
	

local RPGFabi_Stationparams = { }

local function makeNumTracksValues(stationConfig)
	local result = { }

	if stationConfig ~= nil then
		for i = 1, #stationConfig.tracksConfig do
			result[#result + 1] = _("${value}") % { value = stationConfig.tracksConfig[i].num }
		end
	else
		result = { _("1"), _("2"), _("3"), _("4"), _("5") }
	end
			
	return result 
end

local function makeSizeIndexValues(stationConfig, platformConfig)
	local result = { }
	

		result = { _("160 m"), _("240 m"), _("320 m"), _("400 m"), }--_("480 m") }

	
	return result
end


local tracktypes = { _("Standard"), _("High-speed"),  }

function RPGFabi_Stationparams.makeTrackTypeParam()
	return {
		key = "trackType",
		name = _("Track type"),
		values =  { _("Standard"), _("High-speed") },
		yearFrom = 1925,
		yearTo = 0
	}
end



function RPGFabi_Stationparams.makeTrackCatenaryParam()
	return {
		key = "catenary",
		name = _("Catenary"),
		values = { _("No"), _("Yes") },
		defaultIndex = 1,
		yearFrom = 1910,
		yearTo = 0
	}
end

local tramCatenaryYearFrom = 1875

function RPGFabi_Stationparams.makeTramTrackParam1()
	return {
		key = "tramTrack",
		name = _("Tram track"),
		values = { _("No"), _("Yes") },
		yearFrom = 0,
		yearTo = tramCatenaryYearFrom
	}
end

function RPGFabi_Stationparams.makeTramTrackParam2()
	return {
		key = "tramTrack",
		name = _("Tram track"),
		values = { _("No"), _("Yes"), _("Electric") },
		yearFrom = tramCatenaryYearFrom,
		yearTo = 0
	}
end

function RPGFabi_Stationparams.makeTramCatenaryParam()
	return {
		key = "tramCatenary",
		name = _("Catenary"),
		values = { _("No"), _("Yes") },
		defaultIndex = 1,
		yearFrom = tramCatenaryYearFrom,
		yearTo = 0
	}
end

function RPGFabi_Stationparams.makeTruckTerminalsParam()
	return {
		key = "TruckTerminals",
		name = _("Anzahl Truck Terminals"),
		values = { _("0"), _("1"), _("2"), _("3"), _("4") } 
	}
end
function RPGFabi_Stationparams.makeTrainStationParams(stationConfig, platformConfig)

	tracksConfig = tracksConfig or { 1, 2, 3, 4, 5 }

	return {
		{
			key = "numTracksIndex",
			name = _("Number of tracks"),
			values = makeNumTracksValues(stationConfig)	
		},
		{
			key = "sizeIndex",
			name = _("Platform length"),
			values = makeSizeIndexValues(stationConfig, platformConfig),
			defaultIndex = 1
		},
	
		RPGFabi_Stationparams.makeTrackTypeParam(),
		RPGFabi_Stationparams.makeTrackCatenaryParam(),
		RPGFabi_Stationparams.makeTruckTerminalsParam(),
		
		{
			key = "streetSecondConnection",
			name = _("Second street connection"),
			values = { _("No"), _("Yes") } --_("Horizontal"), _("Vertical") }
		},
		{
			key = "buildingplace",
			name = _("Gebäude"),
			values = { _("Links"), _("Rechts"), _("Beide"), _("Keine") },
			defaultIndex = 1
		},
		{
			key = "Bahnuebergang",
			name = _("Bahnübergang"),
			values = { _("Ja"), _("Nein") },
			defaultIndex = 1
		},
		{
			key = "Zusatzgleis",
			name = _("Zusatzgleis"),
			values = { _("Links"), _("Rechts"), _("Keine") },
			defaultIndex = 2
		},
		{
			key = "extrastreet",
			name = _("Extra Street"),
			values = { _("Ja"), _("Nein") },
			defaultIndex = 1 
		},
	
	}
end

function RPGFabi_Stationparams.makeTerminalStationParams()
	return {
		{
			key = "numTerminalsIndex",
			name = _("Number of terminals"),
			values = { _("1"), _("2"), _("3") }
		},
	}
end

return RPGFabi_Stationparams
